package com.yeejoin.amos.boot.module.jg.api.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @author shg
 */
@Data
@ApiModel("监管业务办理统计基础对象")
public class JgBizCountBaseVo implements Serializable {

    public JgBizCountBaseVo() {
        this.id = UUID.randomUUID().toString();
    }
    private String id;

    @ApiModelProperty("业务大类")
    private String bizGroup;

    @ApiModelProperty("业务类型code")
    private String bizType;

    @ApiModelProperty("业务类型名称")
    private String bizTypeName;

    @ApiModelProperty("接收机构")
    private String receiveCompanyName;

    @ApiModelProperty("设备种类")
    private String equListName;

    @ApiModelProperty("设备类别")
    private String equCategoryName;

    @ApiModelProperty("设备品种")
    private String equDefineName;

    @ApiModelProperty("已发起数量")
    private Long launchesNumber;

    @ApiModelProperty("已完成数量")
    private Long finishedNumber;

    @AllArgsConstructor
    @Getter
    public enum BizType {
        /**
         * 业务类型枚举
         */
        maintainNotice("维修告知", "notice"),
        installNotice("安装告知", "notice"),
        transferNotice("移转告知", "notice"),
        reformNotice("改造告知", "notice"),
        maintenanceContract("电梯维保备案", "maintenance"),
        useRegistration("使用登记", "registrer"),
        reformRegistration("改造变更登记", "registrer"),
        transferRegistration("移转变更登记", "registrer"),
        unitRegistration("单位变更登记", "registrer");
        /**
         * 描述
         */
        private String name;

        /**
         * 组
         */
        private String group;


        /**
         * 按照类型获取枚举
         *
         * @param group 分组
         * @return List<Map < String, String>>
         */
        public static List<Map<String, Object>> getBizTypeListByGroup(String group) {
            return Arrays.stream(BizType.values()).filter(e -> e.group.equals(group)).map(e -> {
                Map<String, Object> map = new HashMap<>();
                map.put("key", e);
                map.put("name", e.getName());
                return map;
            }).collect(Collectors.toList());
        }

    }

    public String getBizTypeName() {
        for (BizType c : BizType.values()) {
            if (bizType != null && bizType.equals(c.name())) {
                return c.getName();
            }
        }
        return null;
    }


    public static void sortList(List<JgBizCountBaseVo> list, String sortByField, String sortOrder) {
        Comparator<JgBizCountBaseVo> comparator;
        switch (sortByField) {
            case "launchesNumber":
                comparator = Comparator.comparingLong(JgBizCountBaseVo::getLaunchesNumber);
                break;
            case "finishedNumber":
                comparator = Comparator.comparingLong(JgBizCountBaseVo::getFinishedNumber);
                break;
            default:
                // 默认按 launchesNumber 字段排序
                comparator = Comparator.comparingLong(JgBizCountBaseVo::getLaunchesNumber);
                break;
        }

        if ("desc".equalsIgnoreCase(sortOrder)) {
            comparator = comparator.reversed();
        }

        list.sort(comparator);
    }


}

