package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author Administrator
 */
@Getter
public enum OpenBizTypeEnumV2 {

    /**
     * 业务类型
     */
    JY("jy", "检验机构", "检验业务"),
    JC("jc", "检测机构", "检测业务"),
    SYDW("jc-sydw", "使用单位", "使用单位电梯检测"),
    AGW("jc-agw", "安装改造维修单位", "安改维电梯检测");
    private String code;


    private String unitType;

    private String description;


    private OpenBizTypeEnumV2(String code, String unitType, String description) {
        this.code = code;
        this.unitType = unitType;
        this.description = description;
    }

    public static OpenBizTypeEnumV2 getOneByCode(String code) {
        Optional<OpenBizTypeEnumV2> op = Arrays.stream(OpenBizTypeEnumV2.values()).filter(e -> e.getCode().equals(code)).findFirst();
        return op.orElse(null);
    }

    public static OpenBizTypeEnumV2 getOneByUnitType(String unitType) {
        Optional<OpenBizTypeEnumV2> op = Arrays.stream(OpenBizTypeEnumV2.values()).filter(e -> e.getUnitType().equals(unitType)).findFirst();
        return op.orElse(null);
    }
}
