package com.yeejoin.amos.boot.module.elevator.biz.job;

import com.yeejoin.amos.boot.module.elevator.api.service.IElevatorService;
import lombok.RequiredArgsConstructor;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
public class SynElevator2EsJob {

    private final IElevatorService iElevatorService;

    @Scheduled(cron = "${elevator.syn.insert.job.cron:0 0 2 * * ?}")
    @SchedulerLock(name = "synElevator2Es", lockAtMostFor = "PT1H")
    public void synElevator2Es() {
        iElevatorService.esInsert();
    }

}
