package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationManageDto;
import com.yeejoin.amos.boot.module.jg.api.enums.CompanyTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationManageServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author system_generator
 * @date 2024-07-03
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jg-use-registration-manage")
public class JgUseRegistrationManageController extends BaseController {

    @Autowired
    JgUseRegistrationManageServiceImpl jgUseRegistrationManageServiceImpl;

    /**
     * 将已经通过使用登记审批的证信息录入到 jg-use-registration-manage 表中
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/brushHistoryCertificate")
    @ApiOperation(httpMethod = "POST", value = "将已经通过使用登记审批的证信息录入到 jg-use-registration-manage 表中", notes = "将已经通过使用登记审批的证信息录入到 jg-use-registration-manage 表中")
    public ResponseModel<Boolean> brushHistoryCertificate(@RequestParam(value = "brushType") String brushType) {
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.brushHistoryCertificate(brushType));
    }


    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<JgUseRegistrationManageDto> save(@RequestBody JgUseRegistrationManageDto model) {
        model = jgUseRegistrationManageServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<JgUseRegistrationManageDto> updateBySequenceNbrJgUseRegistrationManage(@RequestBody JgUseRegistrationManageDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询---使用登记证详情用
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/detail")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询---使用登记证详情用", notes = "根据sequenceNbr查询---使用登记证详情用")
    public ResponseModel<JgUseRegistrationManageDto> detail(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.queryDetailBySeq(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询使用登记证操作流水---使用登记证详情用
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/detail/operationRecord")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询使用登记证操作流水---使用登记证详情用", notes = "根据sequenceNbr查询使用登记证操作流水---使用登记证详情用")
    public ResponseModel<List<Map<String, String>>> operationRecord(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.operationRecord(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询使用登记证对应设备列表---使用登记证详情用
     * 分页接口
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/detail/equList")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询使用登记证对应设备列表---使用登记证详情用", notes = "根据sequenceNbr查询使用登记证对应设备列表---使用登记证详情用")
    public ResponseModel<Page<JSONObject>> certificateEquList(@RequestParam(value = "current") int current,
                                                              @RequestParam(value = "size") int size,
                                                              @RequestParam(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.certificateEquList(current, size, sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<JgUseRegistrationManageDto>> queryForPage(JgUseRegistrationManageDto dto,
                                                                        @RequestParam(value = "sort", required = false) String sort,
                                                                        @RequestParam(value = "current") int current,
                                                                        @RequestParam(value = "size") int size) {
        Page<JgUseRegistrationManageDto> page = new Page<JgUseRegistrationManageDto>();
        page.setCurrent(current);
        page.setSize(size);
        ReginParams info = getSelectedOrgInfo();
        if (info.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            dto.setDataType(BaseController.COMPANY_TYPE_COMPANY);
            dto.setUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(info.getCompany().getCompanyType()) ?
                info.getCompany().getCompanyCode().split("_")[1] : info.getCompany().getCompanyCode());
        } else {
            dto.setDataType(BaseController.COMPANY_TYPE_SUPERVISION);
            dto.setReceiveCompanyCode(info.getCompany().getCompanyCode());
        }
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.queryForJgUseRegistrationManagePage(page, dto, sort));
    }
    /**
     * 列表分页查询-大屏监督管理使用
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page/dp")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<JgUseRegistrationManageDto>> getRecords(JgUseRegistrationManageDto dto,
                                                                        @RequestParam(value = "cityCode") String cityCode,
                                                                        @RequestParam(value = "current") int current,
                                                                        @RequestParam(value = "size") int size) {
        Page<JgUseRegistrationManageDto> page = new Page<JgUseRegistrationManageDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.getRecords(page, dto, cityCode));
    }
    /**
     * 按照单位统一代码查询当前单位下的证
     *
     * @param dto dto中的使用单位统一代码（useUnitCreditCode） 非必填，前端不传的话取当前登录单位的统一信用代码 ，有值的话查询该单位的所有证
     * @return 证的列表
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/list")
    @ApiOperation(httpMethod = "GET", value = "按照单位统一代码查询当前单位下的证", notes = "按照单位统一代码查询当前单位下的证")
    public ResponseModel<List<JgUseRegistrationManageDto>> queryByUseUnitCreditCode(JgUseRegistrationManageDto dto) {
        CompanyBo company = getSelectedOrgInfo().getCompany();
        if (company.getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            if (ValidationUtil.isEmpty(dto.getUseUnitCreditCode())) {
                // 不传的话取当前登录单位的统一信用代码
                // 个人主体特殊处理
                dto.setUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                        company.getCompanyCode().split("_")[1] :
                        company.getCompanyCode());
            }
        } else {
            dto.setReceiveCompanyCode(company.getCompanyCode());
        }
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.queryByUseUnitCreditCode(dto));
    }

    /**
     * 根据证的sequenceNbr 查询证下面的所有设备
     *
     * @param sequenceNbr 证的sequenceNbr
     * @return 证下的所有设备
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryEquByCertificateSeq")
    @ApiOperation(httpMethod = "GET", value = "根据证的sequenceNbr 查询证下面的所有设备", notes = "根据证的sequenceNbr 查询证下面的所有设备")
    public ResponseModel<List<JSONObject>> queryEquByCertificateSeq(Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.queryEquByCertificateSeq(sequenceNbr));
    }

    /**
     * 根据证的sequenceNbr 批量查询证下面的所有设备
     *
     * @param sequenceNbrs 证的sequenceNbr集合
     * @return 证下的所有设备
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryEquByCertificateSeqList")
    @ApiOperation(httpMethod = "GET", value = "根据证的sequenceNbr 批量查询证下面的所有设备", notes = "根据证的sequenceNbr 批量查询证下面的所有设备")
    public ResponseModel<List<JSONObject>> queryEquByCertificateSeqList(@RequestParam String sequenceNbrs) {
        List<Long> collect = Arrays.stream(sequenceNbrs.split(","))
                .map(Long::parseLong)
                .collect(Collectors.toList());
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.queryEquByCertificateSeqList(collect));
    }

    /**
     * 根据证的sequenceNbrs 分页查询证下面的所有设备
     *
     * @param current      非必填，不填不分页，展示全部
     * @param size         非必填，不填不分页，展示全部
     * @param sequenceNbrs 证的sequenceNbrs
     * @return 分页结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryEquByCertificateSeqs")
    @ApiOperation(httpMethod = "GET", value = "根据证的sequenceNbr 批量查询证下面的所有设备", notes = "根据证的sequenceNbr 批量查询证下面的所有设备")
    public ResponseModel<Page<JSONObject>> queryEquByCertificateSeqList(@RequestParam(value = "current") int current,
                                                                        @RequestParam(value = "size") int size,
                                                                        @RequestParam(value = "enableType", required = false) String enableType,
                                                                        @RequestParam(value = "sequenceNbrs", required = false ,defaultValue = "1904096657963974658") String sequenceNbrs) {
        if (ObjectUtils.isEmpty(sequenceNbrs)) {
//            1902999963369091074
            throw new BadRequest("请先选择使用登记证");
        }
        List<Long> collect = Arrays.stream(sequenceNbrs.split(","))
                .map(Long::parseLong)
                .collect(Collectors.toList());
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.queryEquForPageByCertificateSeqList(enableType,collect, current, size));
    }

    /**
     * 证的 相关打印
     * @param response 响应
     * @param printType certificateNormalPrint：使用登记证 普打
     *                  certificateNestedPrint：使用登记证 套打
     *                  useFlagNormalPrint：使用标志 普打
     *                  useFlagNestedPrint：使用标志 套打
     *                  exportSummaryTable；工业管道和气瓶 汇总表下载
     * @param certificateSeq 证书的seq
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/printCertificate")
    @ApiOperation(httpMethod = "GET", value = "使用登记证 相关打印", notes = "使用登记证 相关打印")
    public void printCertificate(HttpServletResponse response,
                                 @RequestParam(value = "printType") String printType,
                                 @RequestParam(value = "certificateSeq") String certificateSeq) {
        jgUseRegistrationManageServiceImpl.printCertificate(response,printType, certificateSeq);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/unitChange/page")
    @ApiOperation(httpMethod = "GET", value = "单位变更分页查询", notes = "单位变更分页查询")
    public ResponseModel<Page<JgUseRegistrationManageDto>> queryForUnitChangePage(JgUseRegistrationManageDto dto,
                                                                        @RequestParam(value = "sort", required = false) String sort,
                                                                        @RequestParam(value = "current") int current,
                                                                        @RequestParam(value = "size") int size) {
        Page<JgUseRegistrationManageDto> page = new Page<JgUseRegistrationManageDto>();
        page.setCurrent(current);
        page.setSize(size);
        String originalUseUnitCreditCode = dto.getOriginalUseUnitCreditCode();
        if (!ValidationUtil.isEmpty(originalUseUnitCreditCode)) {
            if(originalUseUnitCreditCode.contains("_")){
                dto.setUseUnitCreditCodeForSearch(originalUseUnitCreditCode.split("_")[0]);
            } else {
                dto.setUseUnitCreditCodeForSearch(originalUseUnitCreditCode);
            }
        } else {
            return ResponseHelper.buildResponse(page);
        }
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.queryForJgUseRegistrationManagePage(page, dto, sort));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/unitChangeByProjectContraption/page")
    @ApiOperation(httpMethod = "GET", value = "单位变更选择工程/装置分页查询", notes = "单位变更选择工程/装置分页查询")
    public ResponseModel<Page<IdxBizJgProjectContraption>> queryForUnitByProjectContraptionPage(@RequestParam Map<String, String> params,
                                                                                  @RequestParam(value = "sort", required = false) String sort,
                                                                                  @RequestParam(value = "current") int current,
                                                                                  @RequestParam(value = "size") int size) {
        Page<IdxBizJgProjectContraption> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        String originalUseUnitCreditCode = params.get("originalUseUnitCreditCode");
        if (ValidationUtil.isEmpty(originalUseUnitCreditCode)) {
            return ResponseHelper.buildResponse(page);
        }else {
            if(originalUseUnitCreditCode.contains("_")){
                params.put("originalUseUnitCreditCode",originalUseUnitCreditCode.split("_")[0]);
            }
        }
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.queryForUnitByProjectContraptionPage(page, params, sort));
    }

    /**
     * 根据sequenceNbr查询---大屏使用
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/detail/dp")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询---大屏使用", notes = "根据sequenceNbr查询---大屏使用")
    public ResponseModel<Object> getDetail(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.getDetail(sequenceNbr));
    }


    /**
     *
     * 初始化使用登记证序列号到Redis
     * @author LiuLin
     * @return Object
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/initRegCodeIntoRedis")
    @ApiOperation(httpMethod = "GET", value = "初始化使用登记证序列号到Redis", notes = "初始化使用登记证序列号到Redis")
    public ResponseModel<Object> initUseRegistrationCodeIntoRedis(@RequestParam(value = "year", defaultValue = "24") String year) {
        jgUseRegistrationManageServiceImpl.initUseRegistrationCodeIntoRedis(year);
        return ResponseHelper.buildResponse(year +"年使用登记证序列码Redis初始化完成!");
    }

    /**
     * 根据sequenceNbr查询---大屏使用
     *
     * @param applyNo 申请单号
     * @return s
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/handleErrorDeviceCode")
    @ApiOperation(httpMethod = "GET", value = "根据applyNo查询证管理表", notes = "根据applyNo查询证管理表")
    public ResponseModel<Object> handleErrorDeviceCode(@RequestParam(value = "applyNo") String applyNo) {
        return ResponseHelper.buildResponse(jgUseRegistrationManageServiceImpl.handleErrorDeviceCode(applyNo));
    }
}
