package com.yeejoin.amos.boot.module.jyjc.api.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionPlanModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * @author system_generator
 * @date 2023-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "tz_jyjc_inspection_application", autoResultMap = true)
public class JyjcInspectionApplication extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 检验检测单位编码
     */
    @TableField("inspection_unit_code")
    private String inspectionUnitCode;

    @TableField("inspection_unit_name")
    private String inspectionUnitName;

    /**
     * 检验检测类型
     */
    @TableField("inspection_type")
    private String inspectionType;

    /**
     * 设备种类
     */
    @TableField("equip_classify")
    private String equipClassify;

    /**
     * 设备类别code
     */
    @TableField("equ_category")
    private String equCategory;

    /**
     * 报检单号
     */
    @TableField("application_no")
    private String applicationNo;

    /**
     * 申请日期
     */
    @TableField("application_date")
    private Date applicationDate;

    /**
     * 检验检测类别
     */
    @TableField("inspection_classify")
    private String inspectionClassify;

    /**
     * 申请联系人
     */
    @TableField("application_contact_name")
    private String applicationContactName;

    /**
     * 申请联系人电话
     */
    @TableField("application_contact_phone")
    private String applicationContactPhone;

    /**
     * 申请说明
     */
    @TableField("application_remark")
    private String applicationRemark;

    /**
     * 项目负责人(检验员)
     */
    @TableField("inspection_charge_person")
    private String inspectionChargePerson;

    @TableField("inspection_charge_person_name")
    private String inspectionChargePersonName;

    /**
     * 项目负责人联系电话（检验员联系电话）
     */
    @TableField("inspection_charge_phone")
    private String inspectionChargePhone;

    /**
     * 说明（受理说明、退回原因、转办说明）
     */
    @TableField("process_description")
    private String processDescription;

    /**
     * 原始报检单号
     */
    @TableField("original_application_no")
    private String originalApplicationNo;

    /**
     * 受理日期
     */
    @TableField("accept_date")
    private Date acceptDate;

    /**
     * 报检单位编号
     */
    @TableField("application_unit_code")
    private String applicationUnitCode;

    @TableField("application_unit_name")
    private String applicationUnitName;

    /**
     * 内部人员代码
     */
    @TableField("inner_person_code")
    private String innerPersonCode;

    /**
     * 包含设备数量（冗余）
     */
    @TableField("number_of_equip")
    private Integer numberOfEquip;

    /**
     * 工作流执行角色
     */
    @TableField("workflow_role")
    private String workflowRole;

    /**
     * 工作流实例ID
     */
    @TableField("instance_id")
    private String processInstanceId;

    /**
     * 申请单二维码
     */
    @TableField("application_qrcode")
    private String applicationQrcode;

    /**
     * 状态
     */
    @TableField("status")
    private String status;

    /**
     * 备注(无用预留)
     */
    @TableField("remark")
    private String remark;

    /**
     * 业务类型（与菜单对应拆表使用）
     */
    @TableField("biz_type")
    private String bizType;

    @TableField("workflow_node")
    private String workflowNode;

    /**
     * 检验结果方式
     */
    @TableField("result_type")
    private String resultType;
    /**
     * 下一执行节点ids
     */
    @TableField("next_execute_ids")
    private String nextExecuteIds;
    /**
     * 发起人id用于撤回操作
     */
    @TableField(value = "promoter")
    private String promoter;

    @TableField(value = "create_user_id")
    private String createUserId;

    @TableField(value = "next_task_id")
    private String nextTaskId;

    @TableField(value = "next_execute_user_ids")
    private String nextExecuteUserIds;

    @TableField(value = "transfer_to_user_ids")
    private String transferToUserIds;

    /**
     * 对接单位code
     */
    @TableField(value = "docking_unit_code")
    private String dockingUnitCode;


    @TableField(value = "plan_data", typeHandler = JacksonTypeHandler.class)
    private JSONObject planData;

    /**
     * 计划下发日期,统计办理时效使用
     */
    @TableField(value = "plan_create_date")
    private Date planCreateDate;

    /**
     * 是否必须处理： true-必须处理，false-可不予受理
     */
    @TableField(value = "is_must_accept")
    private Boolean isMustAccept;

    /**
     * 装置id
     */
    @TableField("project_contraption_id")
    private String projectContraptionId;
}
