package com.yeejoin.amos.boot.module.tcm.biz.service.impl;

import com.yeejoin.amos.boot.module.tcm.api.dto.InspectionDetectionInfoModel;
import com.yeejoin.amos.boot.module.tcm.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.tcm.api.mapper.InspectionDetectionInfoMapper;
import com.yeejoin.amos.boot.module.tcm.api.service.InspectionDetectionInfoService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;


/**
 * 安全追溯-检验检测信息表
 *
 * @author cpp
 * @date 2023-04-06 19:18:21
 */
@Service
public class InspectionDetectionInfoServiceImpl extends BaseService<InspectionDetectionInfoModel, InspectionDetectionInfo, InspectionDetectionInfoMapper> implements InspectionDetectionInfoService {

@Autowired
private InspectionDetectionInfoMapper inspectionDetectionInfo;
    public InspectionDetectionInfoModel selectInspect(String superviseCode) {
        InspectionDetectionInfoModel inspectionDetectionInfoDto = new InspectionDetectionInfoModel();
        if (ValidationUtil.isEmpty(superviseCode)) {
            return  inspectionDetectionInfoDto;
        }
        InspectionDetectionInfo inspectionDetectionInfo = this.inspectionDetectionInfo.selectInspection(superviseCode);
        BeanUtils.copyProperties(inspectionDetectionInfo,inspectionDetectionInfoDto);
        inspectionDetectionInfoDto.setSuperviseCode(superviseCode);
   return inspectionDetectionInfoDto;
    }
}