package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
* 消防员思想谈话记录
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_firefighters_thought")
@ApiModel(value="FirefightersThought对象", description="消防员思想谈话记录")
public class FirefightersThought extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "消防救援人员")
    private Long firefightersId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "谈话时间")
    private Date talkingTime;

    @ApiModelProperty(value = "谈话人")
    private String speaker;

    @ApiModelProperty(value = "思想和现实表现情况")
    private String thoughtMorality;

    @ApiModelProperty(value = "时机原因")
    private String timingReasons;

    @ApiModelProperty(value = "工作措施")
    private String workingMeasures;

    @ApiModelProperty(value = "附件")
    private String enclosure;

    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    private Map<String, List<AttachmentDto>> attachments;

    @ApiModelProperty(value = "更新时间")
    @TableField(fill=FieldFill.UPDATE)
    private Date updateTime;
}
