package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ymt.api.dto.UseInfoModel;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 特种设备基本信息-使用信息 Mapper 接口
 *
 * @author Zhang Yingbin
 * @date 2022-07-19
 */
public interface UseInfoMapper extends BaseMapper<UseInfo> {

  /**
   * 查询检验临期及超期的设备
   * @param statusList 设备状态
   * @param interval 间隔天
   * @return 使用信息
   */
  List<UseInfoModel> queryEquipOfExpireInspection(@Param("statusList") List<String> statusList, @Param("interval") int interval);

  void updateByRecord(String record, Date nextInspectDate, String lastInspectType, String lastInspectReportNo);
}
