package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.api.dto.ContraptionQueryParams;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.common.api.enums.JYJCBusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jyjc.api.common.BizCommonConstant;
import com.yeejoin.amos.boot.module.jyjc.api.entity.*;
import com.yeejoin.amos.boot.module.jyjc.api.enums.*;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcBaseMapper;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationEquipMapper;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.*;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionApplicationService;
import com.yeejoin.amos.boot.module.jyjc.api.vo.JyjcInspectionApplicationVo;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionApplicationPushEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.JgFeignClient;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.adapter.DocGenerateAdapter;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.DocGeneratorFactory;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.dto.DocGenerationRequest;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.support.DocGenerator;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.service.DocUpdateService;
import com.yeejoin.amos.boot.module.jyjc.biz.service.TaskModelServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.typeHandler.EquipCategoryTypeHandler;
import com.yeejoin.amos.boot.module.jyjc.biz.util.CompareUtils;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipTechParamBoiler;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectConstruction;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquimentEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipTechParamBoilerMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgProjectContraptionMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.model.DictionarieModel;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import io.seata.spring.annotation.GlobalTransactional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.RequestBody;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
@Slf4j
public class JyjcInspectionApplicationServiceImpl extends BaseService<JyjcInspectionApplicationModel, JyjcInspectionApplication, JyjcInspectionApplicationMapper> implements IJyjcInspectionApplicationService {

    private static final String EQU_STATE = "EQU_STATE";
    private static final String EQU_CODE = "EQU_CODE";
    private static final String SEQUENCE_NBR = "SEQUENCE_NBR";
    private static final String SUMMIT_TYPE = "0";
    /**
     * 机电类设备种类
     */
    private static final String JD_EQU_LIST_CODES = "3000,4000,5000";

    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    @Lazy
    InspectionPlanServiceImpl inspectionPlanService;

    @Autowired
    private EquipTechParamBoilerMapper equipTechParamBoilerMapper;
    /**
     * 分页查询
     */

    @Autowired
    JyjcInspectionApplicationAttachmentServiceImpl jyjcInspectionApplicationAttachmentService;
    @Autowired
    JyjcInspectionApplicationEquipServiceImpl jyjcInspectionApplicationEquipService;
    @Autowired
    JyjcInspectionApplicationPushLogServiceImpl jyjcInspectionApplicationPushLogService;
    @Autowired
    JyjcOpeningApplicationServiceImpl jyjcOpeningApplicationService;
    @Autowired
    IdxBizJgProjectContraptionMapper jgProjectContraptionMapper;
    @Autowired
    CommonServiceImpl commonService;
    @Autowired
    CmWorkflowServiceImpl cmWorkflowService;
    @Autowired
    JgFeignClient jgFeignClient;
    @Autowired
    TaskModelServiceImpl taskModelService;
    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;
    @Autowired
    RedissonClient redissonClient;
    @Autowired
    JyjcBaseMapper jyjcBaseMapper;
    @Autowired
    JyjcInspectionApplicationNoAcceptLogServiceImpl noAcceptLogService;
    @Autowired
    RestHighLevelClient restHighLevelClient;
    @Autowired
    @Lazy
    private JyjcInspectionResultServiceImpl inspectionResultService;
    @Autowired
    private JyjcInspectionApplicationEquipServiceImpl applicationEquipService;

    @Autowired
    private JyjcInspectionApplicationEquipMapper jyjcInspectionApplicationEquipMapper;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ESEquipmentCategory esEquipmentCategory;
    @Autowired
    private IdxBizJgProjectContraptionMapper idxBizJgProjectContraptionMapper;
    @Autowired
    private JyjcInspectionResultParamServiceImpl jyjcInspectionResultParamServiceImpl;
    @Resource
    private SnowflakeIdUtil sequence;

    @Resource
    private JyjcInspectionHistoryServiceImpl inspectionHistoryService;

    @Resource
    private EquipCategoryTypeHandler typeHandler;

    @Resource
    private EquipCategoryTypeHandler equipCategoryTypeHandler;
    @Autowired
    private JyjcInspectionHistoryServiceImpl jyjcInspectionHistoryServiceImpl;

    @Resource
    private TzBaseEnterpriseInfoMapper baseEnterpriseInfoMapper;

    @Resource
    @Lazy
    private DocGeneratorFactory docGeneratorFactory;

    @Autowired
    private DocGenerateAdapter defaultDocGenerateAdapter;

    @Autowired
    private DocUpdateService docUpdateService;


    @NotNull
    public static List<DictionarieModel> getDictionarieModels(String bizTypes) {
        List<JYJCTypeEnum> enums = JYJCTypeEnum.getListByBizType(bizTypes);
        return enums.stream().map(e -> {
            DictionarieModel dictionarieModel = new DictionarieModel();
            dictionarieModel.setDictCode(e.getCode());
            dictionarieModel.setDictName(e.getName());
            return dictionarieModel;
        }).collect(Collectors.toList());
    }

    @Transactional(rollbackFor = Exception.class)
    public JyjcInspectionApplicationModel save(@RequestBody JSONObject obj, ReginParams reginParams) {
        //接口通用 部分页面按钮无法分开配置类型 所以根据业务情况 将带有工作流实例id的数据 接口类型设置为2 走编辑逻辑
        JyjcInspectionApplicationModel model = JSONObject.parseObject(JSON.toJSONString(obj), JyjcInspectionApplicationModel.class);
        model.setEquip((List<Map<String, Object>>) obj.get("equip"));
        // 校验流程中的不能再次提交
        this.checkForFlowingEquip(model);
        if (CharSequenceUtil.isNotEmpty(model.getProcessInstanceId()) && model.getOperationType().equals("0")) {
            // 之前有工作流，再次提交
            model.setOperationType("2");
        }
        ArrayList<String> roleListAll = new ArrayList<>();
        ArrayList<String> roleListNext = new ArrayList<>();
        if (!"2".equals(model.getOperationType())) {
            String taskName = "";
            if ("0".equals(model.getOperationType())) {  // 工作台提交逻辑、详情页面保存并提交逻辑
                List<ProcessTaskDTO> processTasks = new ArrayList<>();
                ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                List<ActWorkflowStartDTO> list = new ArrayList<>();
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(model.getProcessKey());
                dto.setBusinessKey(String.valueOf(new Date().getTime()));
                dto.setCompleteFirstTask(true);
                list.add(dto);
                actWorkflowBatchDTO.setProcess(list);
                setNameAndIsMustAccept(model);
                dto.setNextExecuteUserCompanyCode(model.getInspectionUnitCode());
                processTasks = cmWorkflowService.startBatch(actWorkflowBatchDTO);
                String instanceId = processTasks.get(0).getProcessInstance().getId();
                String nextTaskId = processTasks.get(0).getNextTask().get(0).getId();
                taskName = processTasks.get(0).getNextTask().get(0).getName();
                this.buildRoleList(processTasks, roleListNext, roleListAll);
                List<WorkflowResultDto> workflowResultDtos = taskModelService.buildWorkFlowInfo(processTasks);
                String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
                String nextExcuteIds = workflowResultDtos.get(0).getNextExecutorRoleIds();
                model.setProcessInstanceId(instanceId);
                model.setInstanceId(instanceId);
                if (!org.springframework.util.ObjectUtils.isEmpty(model.getWorkflowRole())) {
                    model.setWorkflowRole(model.getWorkflowRole() + "," + nextExcuteIds);
                } else {
                    model.setWorkflowRole(nextExcuteIds);
                }
                model.setNextExecuteIds(nextExcuteIds);
                model.setNextTaskId(nextTaskId);
                model.setNextTaskName(taskName);
                model.setPromoter(RequestContext.getExeUserId());
                model.setNextExecuteUserIds(nextUserIds);
                model.setStatus(String.valueOf(FlowStatusEnum.TO_SUBMITTED.getCode())); //6611 对应数据字典 检验流程状态 待受理
                model.setStatusName(FlowStatusEnum.TO_SUBMITTED.getName());
                commonService.saveExecuteFlowData2Redis(model.getProcessInstanceId(), this.buildInstanceRuntimeData(model));
            } else if ("1".equals(model.getOperationType())) {  //  工作台暂存、详情保存逻辑

                if (null == model.getSequenceNbr()) {
                    // 工作台暂存
                    model.setStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
                    model.setStatusName(FlowStatusEnum.TO_BE_SUBMITTED.getName());
                } else {
                    // 详情保存
                    log.info("详情保存,不修改业务状态");
                }
                setNameAndIsMustAccept(model);
            }
            this.setResultTypeAndDockInfo(model);
            model.setApplicationDate(new Date());
            model.setPromoter(reginParams.getUserModel().getUserId());
            model.setApplicationUnitName(reginParams.getCompany().getCompanyName());
            List<JyjcInspectionApplicationEquip> equipInfos = new ArrayList<>();
            if (null != model.getEquip() && !model.getEquip().isEmpty()) {
                List<JyjcInspectionApplicationEquipDto> equips = JSONObject.parseArray(JSON.toJSONString(model.getEquip()), JyjcInspectionApplicationEquipDto.class);
                for (JyjcInspectionApplicationEquipDto equip : equips) {
                    JyjcInspectionApplicationEquip equipInfo = new JyjcInspectionApplicationEquip();
                    equipInfo.setEquDefine(equip.getEquDefineCode());
                    equipInfo.setEquList(equip.getEquListCode());
                    equipInfo.setEquipUnicode(equip.getSequenceNbr());
                    equipInfo.setEquCategory(equip.getEquCategoryCode());
                    equipInfo.setSupervisoryCode(equip.getSupervisoryCode());
                    this.setEquipCategoryIfPieLine(model, equipInfo, equip);
                    equipInfos.add(equipInfo);
                }
                model.setSupervisoryCode(this.getAllSupervisoryCode(equipInfos));
            }
            model.setCreateUserId(reginParams.getUserModel().getUserId());
            model.setNumberOfEquip(equipInfos.size());
            if (null == model.getSequenceNbr()) {
                List<String> codes = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.JY.getCode(), 1).getResult();
                model.setApplicationNo(codes.get(0));
                model = this.createWithModel(model);
                if (StringUtils.isNotBlank(model.getProcessInstanceId())) {
                    this.createdTaskModel(model);
                } else {
                    TaskModelDto dto = new TaskModelDto();
                    TaskMessageDto ta = new TaskMessageDto();
                    ta.setInstanceId(model.getProcessInstanceId());
                    ta.setStatus(model.getStatus());
                    ta.setPromoter(model.getPromoter());
                    ta.setNextExecuteUserIds(model.getNextExecuteUserIds());
                    ta.setSequenceNbr(model.getSequenceNbr());
                    ta.setProcessInstanceId(model.getProcessInstanceId());
                    ta.setProcessKey(model.getProcessKey());
                    ta.setCreateUserId(RequestContext.getExeUserId());
                    ta.setNextTaskId(model.getNextTaskId());
                    dto.setModel(ta);
                    //摘要 按原有规则组装
                    dto.setTaskContent(this.buildTaskContent(model));
                    //申请单号
                    dto.setTaskCode(model.getApplicationNo());
                    //业务类型枚举code值
                    dto.setTaskType(BizTypeEnum.getNumByCode(model.getBizType()));
                    ////业务主键
                    dto.setRelationId(model.getSequenceNbr() + "");
                    taskModelService.buildTaskModel(Collections.singletonList(dto));
                }
            } else {
                jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
                model = this.updateWithModel(model);
                if (StringUtils.isNotBlank(model.getProcessInstanceId()) && model.getOperationType().equals("0")) {
                    taskModelService.deleteTaskModel(model.getSequenceNbr() + "");
                    this.createdTaskModel(model);
                } else {
                    taskModelService.updateTaskContentById(MapBuilder.<String, Object>create().put("taskContent", this.buildTaskContent((model))).put("relationId", model.getSequenceNbr() + "").build());
                }
            }
            for (JyjcInspectionApplicationEquip equipInfo : equipInfos) {
                equipInfo.setApplicationSeq(model.getSequenceNbr());
            }
            applicationEquipService.saveBatch(equipInfos);
            // 附件保存
            jyjcInspectionApplicationAttachmentService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            List<String> enumNameList = DocumentEnum.getEnumNameList();
            for (String code : enumNameList) {
                if (obj.containsKey(code)) {
                    JyjcInspectionApplicationAttachment attachments = new JyjcInspectionApplicationAttachment();
                    attachments.setAttachmentType(code);
                    attachments.setAttachmentUrl(JSONObject.toJSONString(obj.get(code)));
                    attachments.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationAttachmentService.getBaseMapper().insert(attachments);
                }
            }
        } else {
            // 保存并提交
            this.setResultTypeAndDockInfo(model);
            this.setNameAndIsMustAccept(model);
            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            if (!model.getEquip().isEmpty()) {
                List<JyjcInspectionApplicationEquipDto> equips = JSONObject.parseArray(JSON.toJSONString(model.getEquip()), JyjcInspectionApplicationEquipDto.class);
                int num = equips.size();
                model.setNumberOfEquip(num);
                List<JyjcInspectionApplicationEquip> equipInfos = new ArrayList<>();
                for (JyjcInspectionApplicationEquipDto equip : equips) {
                    JyjcInspectionApplicationEquip equipInfo = new JyjcInspectionApplicationEquip();
                    equipInfo.setEquDefine(equip.getEquDefineCode());
                    equipInfo.setEquList(equip.getEquListCode());
                    equipInfo.setEquipUnicode(equip.getSequenceNbr());
                    equipInfo.setEquCategory(equip.getEquCategoryCode());
                    equipInfo.setApplicationSeq(model.getSequenceNbr());
                    this.setEquipCategoryIfPieLine(model, equipInfo, equip);
                    equipInfos.add(equipInfo);
                }
                applicationEquipService.saveBatch(equipInfos);
                model.setSupervisoryCode(this.getAllSupervisoryCode(equipInfos));
            }
            model.setEquList(model.getEquipClassify());
            // 附件更新
            List<String> enumNameList = DocumentEnum.getEnumNameList();

            jyjcInspectionApplicationAttachmentService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            for (String code : enumNameList) {
                if (obj.containsKey(code)) {
                    JyjcInspectionApplicationAttachment attachments = new JyjcInspectionApplicationAttachment();
                    attachments.setAttachmentType(code);
                    attachments.setAttachmentUrl(JSONObject.toJSONString(obj.get(code)));
                    attachments.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationAttachmentService.getBaseMapper().insert(attachments);
                }
            }
            //6611 对应数据字典 检验流程状态 待受理
            model.setStatus(String.valueOf(FlowStatusEnum.TO_SUBMITTED.getCode()));

            ArrayList<String> roleList = new ArrayList<>();
            String taskId = model.getNextTaskId();
            //组装信息
            TaskResultDTO task = new TaskResultDTO();
            task.setResultCode("approvalStatus");
            task.setTaskId(taskId);
            task.setComment("");
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", "提交");
            task.setVariable(map);
            //执行流程
            task.setNextExecuteUserCompanyCode(model.getInspectionUnitCode());
            ProcessTaskDTO processTaskDTO = cmWorkflowService.complete(taskId, task);
            String taskName1 = "";
            String nextTaskId = "";
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleList, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = taskModelService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
            String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
            String executorRoleIds = workflowResultDtos.get(0).getNextExecutorRoleIds();
            if (processTaskDTO != null && processTaskDTO.getNextTask() != null && !processTaskDTO.getNextTask().isEmpty()) {
                taskName1 = processTaskDTO.getNextTask().get(0).getName();
                nextTaskId = processTaskDTO.getNextTask().get(0).getId();
            }
            model.setNextExecuteIds(String.join(",", roleList));
            if (!org.springframework.util.ObjectUtils.isEmpty(model.getWorkflowRole())) {
                model.setWorkflowRole(model.getWorkflowRole() + "," + String.join(",", roleList));
            } else {
                model.setWorkflowRole(String.join(",", roleList));
            }
            model.setNextTaskId(nextTaskId);
            model.setPromoter(RequestContext.getExeUserId());
            model.setStatus(String.valueOf(FlowStatusEnum.TO_SUBMITTED.getCode()));
            model.setStatusName(FlowStatusEnum.TO_SUBMITTED.getName());
            model.setNextTaskName(taskName1);
            model.setNextExecuteIds(executorRoleIds);
            model.setNextExecuteUserIds(nextUserIds);
            createNextTask(model, taskName1, nextUserIds);
            commonService.saveExecuteFlowData2Redis(model.getProcessInstanceId(), this.buildInstanceRuntimeData(model));
            this.updateWithModel(model);
        }
        // 暂存页面数据至his表
        saveHisData(obj, model);
        return this.buildRedundancyField(model);
    }

    private void saveHisData(JSONObject obj, JyjcInspectionApplicationModel model) {
        JyjcInspectionApplication application = new JyjcInspectionApplication();
        BeanUtils.copyProperties(model, application);
        obj.putAll(BeanUtil.beanToMap(application));
        inspectionHistoryService.saveBySeq(model.getSequenceNbr(), obj, model.getInspectionType());
    }

    private String getAllSupervisoryCode(List<JyjcInspectionApplicationEquip> equipInfos) {
        return equipInfos.stream().map(JyjcInspectionApplicationEquip::getSupervisoryCode).filter(supervisoryCode -> !CompareUtils.isNullOrEmpty(supervisoryCode)).collect(Collectors.joining(","));
    }

    private void setEquipCategoryIfPieLine(JyjcInspectionApplicationModel model, JyjcInspectionApplicationEquip equipInfo, JyjcInspectionApplicationEquipDto equipDto) {
        if (model.getEquipClassify().equals(EquipmentClassifityEnum.YLGD.getCode())) {
            equipInfo.setProjectContraptionId(model.getProjectContraptionId());
            equipInfo.setEquList(equipDto.getEquList());
            equipInfo.setEquCategory(equipDto.getEquCategory());
            equipInfo.setEquDefine(equipDto.getEquDefine());
            equipInfo.setEquipUnicode(equipDto.getRecord());
            equipInfo.setSupervisoryCode(equipDto.getPipelineNumber());
        }

    }


    private String buildTaskContent(JyjcInspectionApplicationModel model) {
        String equListName = EquipmentClassifityEnum.getNameByCode(model.getEquipClassify());
        return String.format("来自%s%s的业务办理,【申请单号:%s】", equListName, !CompareUtils.isNullOrEmpty(model.getSupervisoryCode()) ? "【" + model.getSupervisoryCode() + "】" : "", model.getApplicationNo());
    }


    private void setNameAndIsMustAccept(JyjcInspectionApplicationModel model) {
        if (model.getInspectionUnitCode() != null) {
            String[] inspectionUnit = model.getInspectionUnitCode().split("_");
            if (inspectionUnit.length == 2) {
                model.setInspectionUnitCode(inspectionUnit[0]);
                model.setIsMustAccept(Boolean.parseBoolean(inspectionUnit[1]));
                this.setInspectionUnitNameAfterSave(model);
            } else {
                this.setInspectionUnitNameAfterSave(model);
            }
        }
    }

    /**
     * 提交时校验是否有在流程中（流程状态待受理）的设备
     *
     * @param model 提交对象
     */
    private void checkForFlowingEquip(JyjcInspectionApplicationModel model) {
        String operationType = model.getOperationType();
        List<String> recordsInFlowing = new ArrayList<>();
        if (SUMMIT_TYPE.equals(operationType)) {
            List<JyjcInspectionApplicationEquipDto> equips = JSONObject.parseArray(JSON.toJSONString(model.getEquip()), JyjcInspectionApplicationEquipDto.class);
            recordsInFlowing = this.getBaseMapper().queryRecordListInFlowing(equips);
        }
        if (!recordsInFlowing.isEmpty()) {
            throw new BadRequest("存在设备已经在流程中，不允许重复提交检验！");
        }
    }

    private void setInspectionUnitNameAfterSave(JyjcInspectionApplicationModel model) {
        CompanyModel companyModel = jyjcBaseMapper.selectOneCompanyByCode(model.getInspectionUnitCode());
        if (companyModel != null) {
            model.setInspectionUnitName(companyModel.getCompanyName());
        }
    }

    private JyjcInspectionApplicationModel buildRedundancyField(JyjcInspectionApplicationModel model) {
        // 冗余前端显示检验检测类型名称
        if (StringUtils.isNotEmpty(model.getInspectionType())) {
            model.setInspectionTypeName(getInspectionTypeName(model.getInspectionType()));
        }
        model.setEquListName(typeHandler.handle(model.getEquList()));
        return model;
    }

    private String getInspectionTypeName(String inspectionType) {
        DataDictionary dictionary = dataDictionaryService.getByCode(inspectionType, "JYJC");
        return dictionary != null ? dictionary.getName() : "";
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteBatchData(List<Long> sequenceNbr) {
        this.deleteBatchSeq(sequenceNbr);
        for (Long seq : sequenceNbr) {
            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(seq);
            jyjcInspectionApplicationAttachmentService.getBaseMapper().deleteByApplicationSeq(seq);
            jyjcInspectionApplicationPushLogService.getBaseMapper().deleteByApplicationSeq(seq);
            jyjcInspectionHistoryServiceImpl.remove(new LambdaQueryWrapper<JyjcInspectionHistory>().eq(JyjcInspectionHistory::getSSeq, seq));
        }
        return true;
    }

    public Page<JyjcInspectionApplicationEquipModel> listByCategory(Page<JyjcInspectionApplicationEquipModel> page, String equipClassify) {
        return getBaseMapper().listByCategory(page, equipClassify);
    }

    @Override
    public Page<JyjcInspectionApplicationModel> queryForPageList(Page<JyjcInspectionApplication> page, JyjcInspectionApplicationModel model, String sort, String client) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        SortVo sortMap = commonService.sortFieldConversion(sort);
        String companyType = reginParams.getCompany().getCompanyType();
        String companyCode = CommonServiceImpl.getUnitCode(reginParams.getCompany());
        String currentUserId = reginParams.getUserModel().getUserId();
        String currentApplicationUnitCode = null;
        String currentInspectionUnitCode = null;
        if (ValidationUtil.isEmpty(companyType)) {
            return new Page<>(0, 10, 0);
        }
        // 判断当前登录人身份（报检机构、接收机构)
        String identity = CommonServiceImpl.getCompanyIdentityByType(reginParams.getCompany().getCompanyType());
        if (ValidationUtil.equals("apply", identity)) {
            currentApplicationUnitCode = companyCode;
        }
        if (ValidationUtil.equals("receive", identity)) {
            currentInspectionUnitCode = companyCode;
        }
        String orgCode = "jgLook".equals(client) ? reginParams.getCompany().getOrgCode() : null;
        Page<JyjcInspectionApplicationModel> result = this.getBaseMapper().selectForPage(page, model, identity, currentApplicationUnitCode, currentInspectionUnitCode, currentUserId, sortMap, orgCode);
        result.getRecords().forEach(r -> {
            r.setLoginPersonCompanyCode(companyCode);
            this.addPlanAndConfirmStatus(r, model);
        });
        return result;
    }

    public Page<JyjcInspectionApplicationModel> queryForPageList2(Page<JyjcInspectionApplication> page, JyjcInspectionApplicationModel model, String sort) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String client;
        if (reginParams.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) { // 检验检测机构
            client = BaseController.COMPANY_TYPE_COMPANY;
        } else {                                                                               // 监管端
            client = BaseController.COMPANY_TYPE_SUPERVISION;
        }
        SortVo sortMap = commonService.sortFieldConversion(sort);
        String companyCode = CommonServiceImpl.getUnitCode(reginParams.getCompany());
        String agencyClassify  = this.getAgencyClassify(companyCode);
        Page<JyjcInspectionApplicationModel> result = this.getBaseMapper().selectForPage2(page, model, client, companyCode, sortMap, reginParams.getCompany().getOrgCode(), agencyClassify);
        result.getRecords().forEach(r -> {
            r.setLoginPersonCompanyCode(companyCode);
            this.addPlanAndConfirmStatus(r, model);
        });
        return result;
    }

    private String getAgencyClassify(String companyCode) {
        JyjcOpeningApplication openingApplication = getOpeningApplication(companyCode);
        return Optional.ofNullable(openingApplication).map(JyjcOpeningApplication::getAgencyClassify).orElse("none");
    }

    private void addPlanAndConfirmStatus(JyjcInspectionApplicationModel r, JyjcInspectionApplicationModel filter) {
        // 全部时，设置计划状态
        if (String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()).equals(r.getStatus()) && StringUtils.isEmpty(filter.getStatus())) {
            if (StringUtils.isEmpty(r.getInspectionChargePerson())) {
                r.setStatusName(InspectPlanStatusEnum.JS_DFP.getName());
            } else if (StringUtils.isNotEmpty(r.getInspectionChargePerson()) && r.getPlanInspectionDate() == null) {
                r.setStatusName(InspectPlanStatusEnum.JS_YFP_DQR.getName());
            } else {
                r.setStatusName(InspectPlanStatusEnum.JS_YFP_YQR.getName());
            }
        }
        // 进行筛选时，返回筛选的状态
        if (String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()).equals(r.getStatus()) && StringUtils.isNotEmpty(filter.getStatus())) {
            r.setStatusName(InspectPlanStatusEnum.getByValue(filter.getStatus()).getName());
        }
    }

    /**
     * 定（首）检验列表（企业）/ 电梯检测 列表数据导出
     *
     * @param bizType
     * @param response
     * @param ids
     */
    @Override
    public void export(String bizType, HttpServletResponse response, List<String> ids) {
        List<JyjcInspectionApplicationVo> exportData = this.baseMapper.queryExportInIds(ids);
        String typeName;
        if (BizTypeEnum.FIRST_INSPECTION.getCode().equals(bizType)) {
            typeName = "定（首）检验列表";
        } else if (BizTypeEnum.SUPERVISE.getCode().equals(bizType)) {
            typeName = "监督检验列表";
        } else if (BizTypeEnum.ENTRUST.getCode().equals(bizType)) {
            typeName = " 委托检验列表";
        } else {
            typeName = "电梯检测列表";
        }
        ExcelUtil.createTemplate(response, typeName + "数据", typeName, exportData, JyjcInspectionApplicationVo.class, null, false);
    }


    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionApplicationModel> queryForJyjcInspectionApplicationList() {
        return this.queryForList("", false);
    }

    public Map<String, Object> selectBySeq(Long sequenceNbr, String companyType) {
        JyjcInspectionApplicationModel model = this.getBaseMapper().selectDataBySeq(sequenceNbr);
        Map<String, Object> map = BeanUtil.beanToMap(model);
        // 附件
        Map<String, Object> attMap = getAttachmentMap(sequenceNbr);
        JyjcInspectionHistory inspectionHistory = inspectionHistoryService.getBySSeq(sequenceNbr);
        // 已完成的显示json数据 需兼容老数据
        if (model.getStatus().equals(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()))) {
            if (inspectionHistory != null) {
                // 新报检单记录历史数据的逻辑
                map.putAll(inspectionHistory.getHistoryData());
            } else {
                // 兼容逻辑：历史单据之前未记录历史数据的逻辑
                if (model.getEquipClassify().equals(EquipmentClassifityEnum.YLGD.getCode())) {
                    // 压力管道
                    map.putAll(getDeviceListByProjectContraption2(model));
                } else {
                    // 其他设备
                    List<Map<String, Object>> arrayList = getEquipInfoList(sequenceNbr, model);
                    map.put("equip", arrayList);
                }
            }
            map.put("inspectAppUrl", model.getInspectAppUrl());
            map.put("status", model.getStatus());
            map.put("acceptDate", model.getAcceptDate());
            map.put("applicationDate", model.getApplicationDate());
        } else {
            // 未审批完成的显示实时数据
            if (model.getEquipClassify().equals(EquipmentClassifityEnum.YLGD.getCode())) {
                // 压力管道
                map.putAll(getDeviceListByProjectContraption2(model));
            } else {
                // 其他设备
                List<Map<String, Object>> arrayList = getEquipInfoList(sequenceNbr, model);
                map.put("equip", arrayList);
                map.put(BizCommonConstant.TECH_PARAM1, Optional.ofNullable(inspectionHistory).map(JyjcInspectionHistory::getHistoryData).map(s -> s.get(BizCommonConstant.TECH_PARAM1)).orElse(0));
                map.put(BizCommonConstant.TECH_PARAM2, Optional.ofNullable(inspectionHistory).map(JyjcInspectionHistory::getHistoryData).map(s -> s.get(BizCommonConstant.TECH_PARAM2)).orElse(0));
            }
        }
        map.putAll(attMap);
        map.put("companyType", companyType);
        this.setPlanData(sequenceNbr, map);
        return map;
    }

    private List<Map<String, Object>> getEquipInfoList(Long sequenceNbr, JyjcInspectionApplicationModel model) {
        Iterable<ESEquipmentCategoryDto> equips = getEsEquipmentCategoryDtos(sequenceNbr);
        return getEquipListMaps(equips);
    }

    private Map<String, Object> getAttachmentMap(Long sequenceNbr) {
        List<Map<String, Object>> dataByApplicationSeq = jyjcInspectionApplicationAttachmentService.getBaseMapper().getDataByApplicationSeq(sequenceNbr);
        Map<String, Object> attMap = new HashMap<>();
        for (Map<String, Object> maps : dataByApplicationSeq) {
            List<AttachmentDto> data = JSONArray.parseArray(maps.get("attachment_url").toString(), AttachmentDto.class);
            attMap.put(maps.get("attachment_type").toString(), data);
        }
        return attMap;
    }

    private List<Map<String, Object>> getEquipListMaps(Iterable<ESEquipmentCategoryDto> equips) {
        List<Map<String, Object>> arrayList = new ArrayList<>();
        equips.forEach(equip -> {
            Map<String, Object> objectHashMap = new HashMap<>();
            BeanUtil.beanToMap(equip, objectHashMap, false, false);
            objectHashMap.put("record", equip.getSEQUENCE_NBR());
            objectHashMap.put("ADDRESS", concatDetailAddress(equip));
            objectHashMap.forEach((k, v) -> {
                if (ObjectUtils.isEmpty(v) || "null".equals(v)) {
                    objectHashMap.put(k, "");
                }
            });
            arrayList.add(objectHashMap);
        });
        return arrayList;
    }

    private String concatDetailAddress(ESEquipmentCategoryDto esEquipmentCategoryDto) {
        // 省、市、区
        String usePlace = esEquipmentCategoryDto.getUSE_PLACE();
        // 详细地址
        String address = esEquipmentCategoryDto.getADDRESS();
        return String.format("%s%s", usePlace, address);
    }

    private Iterable<ESEquipmentCategoryDto> getEsEquipmentCategoryDtos(Long sequenceNbr) {
        LambdaQueryWrapper<JyjcInspectionApplicationEquip> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(JyjcInspectionApplicationEquip::getApplicationSeq, sequenceNbr);
        wrapper.select(JyjcInspectionApplicationEquip::getEquipUnicode);
        List<JyjcInspectionApplicationEquip> jyjcInspectionApplicationEquips = jyjcInspectionApplicationEquipMapper.selectList(wrapper);
        List<String> records = jyjcInspectionApplicationEquips.stream().map(JyjcInspectionApplicationEquip::getEquipUnicode).distinct().collect(Collectors.toList());
        return esEquipmentCategory.findAllById(records);
    }

    private void setPlanData(Long sequenceNbr, Map<String, Object> map) {
        JSONObject planData = inspectionPlanService.getDetail(String.valueOf(sequenceNbr));
        map.put("planData", planData);
    }

    /**
     * 接收
     *
     * @param params params
     * @return {@link }
     * @throws
     * @author yangyang
     * @date 2023/12/15 15:14
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void doReceive(Map<String, Object> params) {
        String instanceId = params.get("instanceId").toString();
        String nextTaskId = params.get("nextTaskId").toString();
        String lockKey = CommonServiceImpl.buildJcExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);
            Long sequenceNbr = Long.parseLong(params.get("sequenceNbr") + "");
            JyjcInspectionApplication jyjcInspectionApplication = this.getBaseMapper().selectById(sequenceNbr);
            //组装信息
            TaskResultDTO task = new TaskResultDTO();
            task.setResultCode("approvalStatus");
            task.setTaskId(nextTaskId);
            task.setComment(params.getOrDefault("comments", "").toString());
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", "0");
            task.setVariable(map);
            //执行流程
            task.setNextExecuteUserCompanyCode(jyjcInspectionApplication.getInspectionUnitCode());
            cmWorkflowService.complete(nextTaskId, task);
            jyjcInspectionApplication.setStatus(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
            JyjcInspectionApplicationModel model = new JyjcInspectionApplicationModel();
            model.setStatusName(FlowStatusEnum.TO_BE_FINISHED.getName());
            jyjcInspectionApplication.setAcceptDate(new Date());
            jyjcInspectionApplication.setInnerPersonCode(params.getOrDefault("innerPersonCode", "").toString());
            String processDescription = (String) params.get("comments");
            if (StringUtils.isNotBlank(processDescription)) {
                jyjcInspectionApplication.setProcessDescription(processDescription);
            }
            jyjcInspectionApplication.setNextExecuteUserIds("");
            jyjcInspectionApplication.setPromoter("");
            jyjcInspectionApplication.setNextExecuteIds("");
            jyjcInspectionApplication.setNextTaskId("");
            this.updateById(jyjcInspectionApplication);
            BeanUtils.copyProperties(jyjcInspectionApplication, model);
            TaskV2Model taskV2Model = updateTaskModel(model);
            List<JyjcInspectionApplicationEquipModel> applicationEquipModels = applicationEquipService.listApplicationEquipByApplicationSeq(sequenceNbr);
            List<JyjcInspectionResult> resultModels = new ArrayList<>();
            List<JgResumeInfoDto> jgResumeInfoDtoList = new ArrayList<>();
            Date now = DateUtil.date();
            if (model.getEquipClassify().equals(EquipmentClassifityEnum.YLGD.getCode())) {
                List<String> codes = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.SE.getCode(), 1).getResult();
                JyjcInspectionResult resultModel = new JyjcInspectionResult();
                resultModel.setInspectionUnitCode(model.getInspectionUnitCode());
                resultModel.setInspectionUnitName(model.getInspectionUnitName());
                resultModel.setApplicationNo(model.getApplicationNo());
                resultModel.setApplicationUnitCode(model.getApplicationUnitCode());
                resultModel.setApplicationUnitName(model.getApplicationUnitName());
                resultModel.setResultStatus(ResultStatusEnum.NO_RESULT.getCode());
                resultModel.setApplicationDate(model.getApplicationDate());
                resultModel.setRecDate(now);
                resultModel.setInspectionType(model.getInspectionType());
                resultModel.setInspectionTypeName(this.getDictNameByCode(model.getInspectionType()));
                // 解析设备
                resultModel.setBizType(model.getBizType());
                resultModel.setResultNo(codes.get(0));
                // 装置信息查询
                resultModel.setEquipUnicode(model.getProjectContraptionId());
                IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionMapper.selectById(model.getProjectContraptionId());
                if (projectContraption != null) {
                    resultModel.setEquipUnicode(projectContraption.getSequenceNbr() + "");
                    resultModel.setSupervisoryCode(projectContraption.getSupervisoryCode());
                    resultModel.setEquCategory(projectContraption.getEquCategory());
                    resultModel.setEquList(projectContraption.getEquList());
                    resultModel.setEquDefine(projectContraption.getEquDefine());
                }
                Long resultSeq = sequence.nextId();
                resultModel.setSequenceNbr(resultSeq);
                resultModel.setIsExistNc(false);
                resultModel.setManageType("batch");
                resultModel.setResultType(model.getResultType());
                resultModels.add(resultModel);
                // TODO 以管道汇总样式表暂存json,在结果录入后，将数据更新技术参数,考虑老数据
                Map<String, Object> paramDetail = getDeviceListByProjectContraption3(model);
                JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
                resultParam.setResultSeq(resultModel.getSequenceNbr());
                resultParam.setParamJson(JSON.toJSONString(paramDetail));
                resultParam.setParamType("IdxBizJgTechParamsPipeline");
                resultParam.setRecDate(new Date());
                jyjcInspectionResultParamServiceImpl.save(resultParam);
                jgResumeInfoDtoList.add(JgResumeInfoDto.builder().applyNo(jyjcInspectionApplication.getApplicationNo())
                        .businessType(resultModel.getInspectionTypeName())
                        .businessId(String.valueOf(jyjcInspectionApplication.getSequenceNbr()))
                        .changeContent(resultModel.getInspectionTypeName() + "业务办理")
                        .equId(resultModel.getEquipUnicode())
                        .approvalUnit(model.getInspectionUnitName())
                        .approvalUnitCode(model.getInspectionUnitCode())
                        .status("正常")
                        .routePath(taskV2Model.getRoutePath()).build());
            } else {
                List<String> codes = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.SE.getCode(), applicationEquipModels.size()).getResult();
                for (int i = 0; i < applicationEquipModels.size(); i++) {
                    JyjcInspectionResult resultModel = new JyjcInspectionResult();
                    resultModel.setInspectionUnitCode(model.getInspectionUnitCode());
                    resultModel.setInspectionUnitName(model.getInspectionUnitName());
                    resultModel.setApplicationNo(model.getApplicationNo());
                    resultModel.setApplicationUnitCode(model.getApplicationUnitCode());
                    resultModel.setApplicationUnitName(model.getApplicationUnitName());
                    resultModel.setResultStatus(ResultStatusEnum.NO_RESULT.getCode());
                    resultModel.setApplicationDate(model.getApplicationDate());
                    resultModel.setRecDate(now);
                    resultModel.setInspectionType(model.getInspectionType());
                    resultModel.setInspectionTypeName(this.getDictNameByCode(model.getInspectionType()));
                    // 解析设备
                    resultModel.setBizType(model.getBizType());
                    resultModel.setResultNo(codes.get(i));
                    //设备唯一标识
                    resultModel.setEquipUnicode(applicationEquipModels.get(i).getEquipUnicode());
                    resultModel.setSupervisoryCode(applicationEquipModels.get(i).getSupervisoryCode());
                    resultModel.setEquDefine(applicationEquipModels.get(i).getEquDefine());
                    resultModel.setEquCategory(applicationEquipModels.get(i).getEquCategory());
                    resultModel.setEquList(applicationEquipModels.get(i).getEquList());
                    resultModel.setIsExistNc(false);
                    resultModel.setResultType(model.getResultType());
                    Long resultSeq = sequence.nextId();
                    resultModel.setSequenceNbr(resultSeq);
                    resultModels.add(resultModel);
                    // TODO 暂存json,在结果录入后，将数据更新技术参数-检验详情使用 考虑兼容老数据
                    // 新增设备履历信息
                    jgResumeInfoDtoList.add(JgResumeInfoDto.builder().applyNo(jyjcInspectionApplication.getApplicationNo())
                            .businessType(resultModel.getInspectionTypeName())
                            .businessId(String.valueOf(jyjcInspectionApplication.getSequenceNbr()))
                            .changeContent(resultModel.getInspectionTypeName() + "业务办理")
                            .equId(applicationEquipModels.get(i).getEquipUnicode())
                            .approvalUnit(model.getInspectionUnitName())
                            .approvalUnitCode(model.getInspectionUnitCode())
                            .status("正常")
                            .routePath(taskV2Model.getRoutePath()).build());
                }
            }
            inspectionResultService.saveOrUpdateBatch(resultModels);
            // 报检信息推送
            this.pushInspectionApplication(model);
            this.createHisAfterReceive(model);
            // 设备检验履历
            this.saveBatchResume(jgResumeInfoDtoList);
            // 更新流程中的流程数据
            commonService.saveExecuteFlowData2Redis(model.getProcessInstanceId(), this.buildInstanceRuntimeData(jyjcInspectionApplication));
            // 事务提交后，生成报检申请表
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
                @Override
                public void afterCommit() {
                    docUpdateService.genDocAndUpdate(model.getSequenceNbr() + "");
                }
            });
        } catch (InterruptedException e) {
            log.error(e.getMessage(), e);
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    private void setResultTypeAndDockInfo(JyjcInspectionApplicationModel applicationModel) {
        LambdaQueryWrapper<JyjcOpeningApplication> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JyjcOpeningApplication::getUnitCode, applicationModel.getInspectionUnitCode());
        queryWrapper.eq(JyjcOpeningApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getName());
        queryWrapper.select(JyjcOpeningApplication::getResultType, BaseEntity::getSequenceNbr, JyjcOpeningApplication::getDockingUnitCode);
        queryWrapper.orderByDesc(JyjcOpeningApplication::getRecDate);
        queryWrapper.last("limit 1");
        List<JyjcOpeningApplication> applicationList = jyjcOpeningApplicationService.list(queryWrapper);
        if (!applicationList.isEmpty()) {
            applicationModel.setResultType(applicationList.get(0).getResultType());
            applicationModel.setDockingUnitCode(applicationList.get(0).getDockingUnitCode());
        }
    }

    private JyjcOpeningApplication getOpeningApplication(String inspectionUnitCode) {
        LambdaQueryWrapper<JyjcOpeningApplication> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JyjcOpeningApplication::getUnitCode, inspectionUnitCode);
        queryWrapper.eq(JyjcOpeningApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getName());
        queryWrapper.select(JyjcOpeningApplication::getResultType, BaseEntity::getSequenceNbr, JyjcOpeningApplication::getDockingUnitCode, JyjcOpeningApplication::getAgencyClassify);
        queryWrapper.orderByDesc(JyjcOpeningApplication::getRecDate);
        queryWrapper.last("limit 1");
       return jyjcOpeningApplicationService.getOne(queryWrapper);

    }


    public void createHisAfterReceive(JyjcInspectionApplicationModel model) {
        if (model.getEquipClassify().equals(EquipmentClassifityEnum.YLGD.getCode())) {
            JSONObject hisData = getDeviceListByProjectContraption2(model);
            inspectionHistoryService.saveBySeq(model.getSequenceNbr(), hisData, model.getInspectionType());
        } else {
            JyjcInspectionHistory inspectionHistory = inspectionHistoryService.getBySSeq(model.getSequenceNbr());
            if (inspectionHistory != null) {
                JSONObject hisData = inspectionHistory.getHistoryData();
                List<Map<String, Object>> arrayList = getEquipInfoList(model.getSequenceNbr(), model);
                hisData.put("equip", arrayList);
                inspectionHistoryService.saveBySeq(model.getSequenceNbr(), hisData, model.getInspectionType());
            } else {
                List<Map<String, Object>> arrayList = getEquipInfoList(model.getSequenceNbr(), model);
                JSONObject hisData = new JSONObject();
                hisData.put("equip", arrayList);
                inspectionHistoryService.saveBySeq(model.getSequenceNbr(), hisData, model.getInspectionType());
            }
        }
    }


    private void saveBatchResume(List<JgResumeInfoDto> jgResumeInfoDtoList) {
        try {
            jgFeignClient.saveBatchResume(jgResumeInfoDtoList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public void pushInspectionApplication(JyjcInspectionApplicationModel inspectionApplicationModel) {
        // 将检验检测申请信息推送至对应的检验机构
        if (ResultTypeEnum.INTEGRATED.getCode().equals(inspectionApplicationModel.getResultType())) {
            InspectionApplicationPushEvent event = new InspectionApplicationPushEvent(this, inspectionApplicationModel);
            eventPublisher.publish(event);
        }
    }

    private String getDictNameByCode(String code) {
        DataDictionary dataDictionary = dataDictionaryService.getByCode(code, "JYJC");
        return dataDictionary != null ? dataDictionary.getName() : "";
    }

    /**
     * 退回
     *
     * @param params params
     * @return {@link }
     * @throws
     * @author yangyang
     * @date 2023/12/15 15:14
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public Boolean doReject(Map<String, Object> params) {
        String instanceId = params.get("instanceId").toString();
        String nextTaskId = params.get("nextTaskId").toString();
        String lockKey = CommonServiceImpl.buildJcExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);
            Long sequenceNbr = Long.parseLong(params.get("sequenceNbr") + "");
            JyjcInspectionApplicationModel model = this.queryBySeq(sequenceNbr);
            ArrayList<String> roleListAll = new ArrayList<>();
            ArrayList<String> roleList = new ArrayList<>();
            String taskId = model.getNextTaskId();
            //组装信息
            TaskResultDTO task = new TaskResultDTO();
            task.setResultCode("approvalStatus");
            task.setTaskId(taskId);
            task.setComment(params.getOrDefault("comments", "").toString());
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", "1");
            task.setVariable(map);
            //执行流程
            task.setNextExecuteUserCompanyCode(model.getInspectionUnitCode());
            ProcessTaskDTO processTaskDTO = cmWorkflowService.reject(taskId, task);
            String nextTaskName = "";
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleList, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = taskModelService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));

            model.setStatus(String.valueOf(FlowStatusEnum.REJECTED.getCode()));
            model.setStatusName(FlowStatusEnum.REJECTED.getName());
            String processDescription = (String) params.get("comments");
            if (StringUtils.isNotBlank(processDescription)) {
                model.setProcessDescription(processDescription);
            }
            String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
            String executorRoleIds = workflowResultDtos.get(0).getNextExecutorRoleIds();
            nextTaskName = workflowResultDtos.get(0).getNextTaskName();
            nextTaskId = workflowResultDtos.get(0).getNextTaskId();
            model.setNextExecuteIds(String.join(",", roleList));
            if (!org.springframework.util.ObjectUtils.isEmpty(model.getWorkflowRole())) {
                model.setWorkflowRole(model.getWorkflowRole() + "," + String.join(",", roleList));
            } else {
                model.setWorkflowRole(String.join(",", roleList));
            }
            model.setNextTaskId(nextTaskId);
            model.setPromoter(RequestContext.getExeUserId());
            model.setNextTaskName(nextTaskName);
            model.setNextExecuteIds(executorRoleIds);
            model.setNextExecuteUserIds(nextUserIds);
            createNextTask(model, nextTaskName, nextUserIds);
            this.updateWithModel(model);
            // 更新流程中的流程数据
            commonService.saveExecuteFlowData2Redis(model.getProcessInstanceId(), this.buildInstanceRuntimeData(model));
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return true;
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public Boolean doNoAccept(Map<String, Object> params) {
        String instanceId = params.get("instanceId").toString();
        String nextTaskId = params.get("nextTaskId").toString();
        String lockKey = CommonServiceImpl.buildJcExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);
            Long sequenceNbr = Long.parseLong(params.get("sequenceNbr") + "");
            JyjcInspectionApplicationModel model = this.queryBySeq(sequenceNbr);
            ArrayList<String> roleListAll = new ArrayList<>();
            ArrayList<String> roleList = new ArrayList<>();
            String taskId = model.getNextTaskId();
            //组装信息
            TaskResultDTO task = new TaskResultDTO();
            task.setResultCode("approvalStatus");
            task.setTaskId(taskId);
            task.setComment(params.getOrDefault("comments", "").toString());
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", "8");
            task.setVariable(map);
            //执行流程
            task.setNextExecuteUserCompanyCode(model.getInspectionUnitCode());
            ProcessTaskDTO processTaskDTO = cmWorkflowService.reject(taskId, task);
            String nextTaskName = "";
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleList, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = taskModelService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));

            model.setStatus(String.valueOf(FlowStatusEnum.NO_ACCEPT.getCode()));
            model.setStatusName(FlowStatusEnum.NO_ACCEPT.getName());
            String processDescription = (String) params.get("comments");
            if (StringUtils.isNotBlank(processDescription)) {
                model.setProcessDescription(processDescription);
            }
            String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
            String executorRoleIds = workflowResultDtos.get(0).getNextExecutorRoleIds();
            nextTaskName = workflowResultDtos.get(0).getNextTaskName();
            nextTaskId = workflowResultDtos.get(0).getNextTaskId();
            model.setNextExecuteIds(String.join(",", roleList));
            if (!org.springframework.util.ObjectUtils.isEmpty(model.getWorkflowRole())) {
                model.setWorkflowRole(model.getWorkflowRole() + "," + String.join(",", roleList));
            } else {
                model.setWorkflowRole(String.join(",", roleList));
            }
            model.setNextTaskId(nextTaskId);
            model.setPromoter(RequestContext.getExeUserId());
            model.setNextTaskName(nextTaskName);
            model.setNextExecuteIds(executorRoleIds);
            model.setNextExecuteUserIds(nextUserIds);
            createNextTask(model, nextTaskName, nextUserIds);
            this.updateWithModel(model);
            this.createNoAcceptLog(model);
            // 更新流程中的流程数据
            commonService.saveExecuteFlowData2Redis(model.getProcessInstanceId(), this.buildInstanceRuntimeData(model));
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return true;
    }

    private void createNoAcceptLog(JyjcInspectionApplicationModel model) {
        JyjcInspectionApplicationNoAcceptLogModel noAcceptLogModel = new JyjcInspectionApplicationNoAcceptLogModel();
        noAcceptLogModel.setApplicationSeq(model.getSequenceNbr());
        noAcceptLogModel.setInspectionUnitCode(model.getInspectionUnitCode());
        noAcceptLogModel.setNoAcceptUserId(RequestContext.getExeUserId());
        noAcceptLogModel.setRemark(model.getProcessDescription());
        noAcceptLogService.createWithModel(noAcceptLogModel);
    }

    /**
     * 撤回流程办理单
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public Boolean doRollback(String sequenceNbr, String instanceId, String nextTaskId) {
        String lockKey = CommonServiceImpl.buildJcExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForRevocationFlow(nextTaskId, instanceId);
            JyjcInspectionApplicationModel inspectionApplicationModel = this.queryBySeq(Long.valueOf(sequenceNbr));
            if (inspectionApplicationModel == null) {
                log.warn("JyjcInspectionApplicationModel Not Found！sequenceNbr => " + sequenceNbr);
                return false;
            }
            List<String> roleListNext = new ArrayList<>();
            List<String> roleListAll = new ArrayList<>();
            ProcessTaskDTO processTaskDTO = cmWorkflowService.rollBack(inspectionApplicationModel.getProcessInstanceId());
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = taskModelService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
            if (!org.springframework.util.ObjectUtils.isEmpty(inspectionApplicationModel.getWorkflowRole())) {
                inspectionApplicationModel.setWorkflowRole(inspectionApplicationModel.getWorkflowRole() + "," + roleListAll);
            } else {
                inspectionApplicationModel.setWorkflowRole(inspectionApplicationModel.getWorkflowRole());
            }
            inspectionApplicationModel.setNextTaskId(processTaskDTO.getNextTask().get(0).getId());
            inspectionApplicationModel.setStatus(String.valueOf(FlowStatusEnum.ROLLBACK.getCode()));
            inspectionApplicationModel.setStatusName(FlowStatusEnum.ROLLBACK.getName());
            inspectionApplicationModel.setPromoter("");
            inspectionApplicationModel.setNextExecuteUserIds(workflowResultDtos.get(0).getNextExecutorUserIds());
            inspectionApplicationModel.setNextExecuteIds(String.join(",", roleListNext));
            JyjcInspectionApplication jyjcInspectionApplication = new JyjcInspectionApplication();
            BeanUtils.copyProperties(inspectionApplicationModel, jyjcInspectionApplication);
            this.getBaseMapper().updateById(jyjcInspectionApplication);
            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(inspectionApplicationModel));
            jsonObject.put("nextTaskId", inspectionApplicationModel.getNextTaskId());
            jsonObject.put("nextExecuteUser", inspectionApplicationModel.getNextExecuteIds());
            jsonObject.put("taskType", BizTypeEnum.getNumByCode(inspectionApplicationModel.getBizType()));
            jsonObject.put("flowStatus", FlowStatusEnum.ROLLBACK.getCode());
            jsonObject.put("flowStatusLabel", FlowStatusEnum.ROLLBACK.getName());
            taskModelService.rollbackTask(inspectionApplicationModel.getProcessInstanceId(), jsonObject);
            // 缓存下一个任务id,再任务进行时，用来校验数据，不再进行数据库查询
            commonService.saveExecuteFlowData2Redis(instanceId, this.buildInstanceRuntimeData(jyjcInspectionApplication));
            return true;
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return Boolean.FALSE;

    }

    private InstanceRuntimeData buildInstanceRuntimeData(JyjcInspectionApplication jyjcInspectionApplication) {
        return InstanceRuntimeData.builder().nextExecuteUserIds(jyjcInspectionApplication.getNextExecuteUserIds()).promoter(jyjcInspectionApplication.getPromoter()).nextTaskId(jyjcInspectionApplication.getNextTaskId()).build();
    }

    private InstanceRuntimeData buildInstanceRuntimeData(JyjcInspectionApplicationModel jyjcInspectionApplication) {
        return InstanceRuntimeData.builder().nextExecuteUserIds(jyjcInspectionApplication.getNextExecuteUserIds()).promoter(jyjcInspectionApplication.getPromoter()).nextTaskId(jyjcInspectionApplication.getNextTaskId()).build();
    }

    private void buildRoleList(List<ProcessTaskDTO> processTasks, List<String> roleListNext, List<String> roleListAll) {
        processTasks.forEach(p -> {
            p.getNextCandidateGroups().values().forEach(e -> {
                roleListNext.addAll(e);
                roleListAll.addAll(e);
            });
            roleListAll.addAll(p.getCandidateGroups());
        });
    }

    private void createdTaskModel(JyjcInspectionApplicationModel model) {

        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        TaskModelDto dto = new TaskModelDto();
        TaskMessageDto ta = new TaskMessageDto();
        ta.setInstanceId(model.getProcessInstanceId());
        ta.setStatus(model.getStatus());
        ta.setPromoter(model.getPromoter());
        ta.setNextExecuteIds(model.getNextExecuteIds());
        ta.setSequenceNbr(model.getSequenceNbr());
        ta.setProcessInstanceId(model.getProcessInstanceId());
        ta.setProcessKey(model.getProcessKey());
        ta.setInspectionUnitCode(model.getInspectionUnitCode());
        ta.setNextTaskId(model.getNextTaskId());
        ta.setBizType(model.getBizType());
        dto.setModel(ta);
        dto.setFlowCreateDate(new Date());
        dto.setTaskName(model.getNextTaskName());
        dto.setFlowCode(model.getNextTaskId());
        dto.setTaskContent(this.buildTaskContent(model));
        dto.setTaskCode(model.getApplicationNo());
        dto.setTaskType(BizTypeEnum.getNumByCode(model.getBizType()));
        dto.setTaskTypeLabel(BizTypeEnum.getNameByCode(model.getBizType()));
        dto.setRelationId(model.getProcessInstanceId());
        dto.setExecuteUserIds(model.getNextExecuteUserIds());
        dto.setTaskStatusLabel("未处理");
        dto.setFlowStatus(Integer.valueOf(model.getStatus()));
        dto.setFlowStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
        dto.setStartUserId(RequestContext.getExeUserId());
        dto.setStartUser(reginParams.getUserModel().getRealName());
        dto.setStartUserCompanyName(reginParams.getCompany().getCompanyName());
        dto.setStartDate(new Date());
        dto.setNextExecuteUser(model.getNextExecuteIds());

        taskModelService.buildTaskModel(Collections.singletonList(dto));
    }

    private void createNextTask(JyjcInspectionApplicationModel model, String taskName, String nextUserIds) {
        // 先更新之前的待办
        TaskV2Model taskV2Model = updateTaskModel(model);
        taskV2Model.setTaskDesc("");
        taskV2Model.setTaskName(taskName);
        taskV2Model.setTaskCode(model.getApplicationNo());
        taskV2Model.setExecuteUserIds(nextUserIds);
        taskV2Model.setRelationId(model.getProcessInstanceId());
        taskV2Model.setTaskStatus(Integer.valueOf(model.getStatus()));
        taskV2Model.setTaskStatusLabel(model.getStatusName());
        taskV2Model.setFlowStatus(Integer.valueOf(model.getStatus()));
        taskV2Model.setFlowStatusLabel(model.getStatusName());
        TaskModelDto modelDto = new TaskModelDto();
        BeanUtil.copyProperties(taskV2Model, modelDto);
        modelDto.setNextExecuteUser(model.getNextExecuteIds());
        if (model.getStatus().equals(FlowStatusEnum.REJECTED.getCode() + "")) {
            modelDto.setPageType("edit");
        }
        TaskMessageDto obj = new TaskMessageDto();
        obj.setInstanceId(model.getProcessInstanceId());
        obj.setStatus(model.getStatus());
        obj.setNextTaskId(model.getNextTaskId());
        obj.setPromoter(model.getPromoter());
        obj.setNextExecuteUserIds(model.getNextExecuteUserIds());
        obj.setSequenceNbr(model.getSequenceNbr());
        obj.setNextExecuteIds(model.getNextExecuteIds());
        obj.setProcessInstanceId(model.getProcessInstanceId());
        obj.setProcessKey(model.getProcessKey());
        obj.setInspectionUnitCode(model.getInspectionUnitCode());
        obj.setBizType(model.getBizType());
        obj.setCreateUserId(model.getCreateUserId());
        modelDto.setModel(obj);
        // 再插入新代办、数据待定
        taskModelService.buildTaskModel(Collections.singletonList(modelDto));
    }

    private TaskV2Model updateTaskModel(JyjcInspectionApplicationModel model) {
        Map<String, Object> params = new HashMap<>();
        params.put("relationId", model.getProcessInstanceId());
        params.put("taskStatus", model.getStatus());
        params.put("taskStatusLabel", model.getStatusName());
        params.put("flowStatus", model.getStatus());
        params.put("flowStatusLabel", model.getStatusName());
        JSONObject jsonModel = (JSONObject) JSONObject.toJSON(model);
        taskModelService.removeNoUsedKey(jsonModel);
        Map<String, Object> modelMap = new HashMap<>(jsonModel);
        params.put("model", BeanUtil.toBeanIgnoreError(modelMap, JyjcInspectionApplicationModel.class));
        return taskModelService.updateTaskModel(params);
    }

    /**
     * 缓存当前正在流程中的实例的流程数据
     */
    public void initFlowData2Redis() {
        LambdaQueryWrapper<JyjcInspectionApplication> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.ne(JyjcInspectionApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getCode());
        queryWrapper.ne(JyjcInspectionApplication::getStatus, FlowStatusEnum.TO_BE_DISCARD.getCode());
        queryWrapper.isNotNull(JyjcInspectionApplication::getProcessInstanceId);
        queryWrapper.select(JyjcInspectionApplication::getProcessInstanceId, JyjcInspectionApplication::getNextTaskId, JyjcInspectionApplication::getPromoter, JyjcInspectionApplication::getNextExecuteUserIds);
        List<JyjcInspectionApplication> jyjcInspectionApplicationsInFlowing = this.list(queryWrapper);
        jyjcInspectionApplicationsInFlowing.forEach(inspectionApplication -> {
            commonService.saveExecuteFlowData2Redis(inspectionApplication.getProcessInstanceId(), this.buildInstanceRuntimeData(inspectionApplication));
        });
    }

    /**
     * 获取当前登录人单位类型
     */
    public JSONObject getCompanyType() {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        CompanyBo company = reginParams.getCompany();
        JSONObject object = new JSONObject();
        object.put("level", company.getLevel());
        object.put("orgCode", company.getOrgCode());
        object.put("companyName", company.getCompanyName());
        object.put("companyCode", company.getCompanyCode());
        object.put("companyType", company.getCompanyType());
        return object;
    }

    /**
     * 设备查询-所有设备-未做业务限制
     *
     * @param map 查询参数
     * @return 设备分页
     */
    public Page<JSONObject> getAllEquipListPage(JSONObject map) {
        int pageNumber = ObjectUtils.isEmpty(map.getInteger("number")) ? 1 : map.getInteger("number");
        int size = ObjectUtils.isEmpty(map.getInteger("size")) ? 20 : map.getInteger("size");
        Page<JSONObject> result = new Page<>(pageNumber, size);
        SearchRequest request = new SearchRequest();
        request.indices("idx_biz_equipment_info");
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.trackTotalHits(true);
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();

        // 获取当前登录人单位类型
        JSONObject company = getCompanyType();
        if (ValidationUtil.isEmpty(company)) {
            result.setRecords(new ArrayList<>());
            result.setTotal(0);
            return result;
        }
        String companyCode = company.getString("companyCode").contains("_") ? company.getString("companyCode").split("_")[1] : company.getString("companyCode");
        String type = company.getString("companyType");

        // 根据当前登录用户类型及管辖机构筛选条件添加对应参数
        if (!ValidationUtil.isEmpty(type) && type.contains("使用单位")) {
            if (ValidationUtil.isEmpty(map.getString("USE_UNIT_CREDIT_CODE"))) {
                map.put("USE_UNIT_CREDIT_CODE", companyCode);
            }
        }
        if (!ValidationUtil.isEmpty(type) && type.contains("安装改造维修单位")) {
            map.put("USC_UNIT_CREDIT_CODE", companyCode);
        }
        if (!ValidationUtil.isEmpty(type) && type.contains("个人主体")) {
            map.put("USE_UNIT_CREDIT_CODE", companyCode);
        }

        // 使用单位 //安装改造维修单位
        if (!ObjectUtils.isEmpty(map.getString("USE_UNIT_CREDIT_CODE")) && !ObjectUtils.isEmpty(map.getString("USC_UNIT_CREDIT_CODE"))) {
            BoolQueryBuilder ubuilder = QueryBuilders.boolQuery();
            String useCode = QueryParser.escape(map.getString("USE_UNIT_CREDIT_CODE"));
            useCode = useCode.contains("_") ? useCode.split("_")[0] : useCode;
            ubuilder.should(QueryBuilders.matchQuery("USE_UNIT_CREDIT_CODE", useCode));

            String uscCode = QueryParser.escape(map.getString("USC_UNIT_CREDIT_CODE")).toLowerCase();
            ubuilder.should(QueryBuilders.wildcardQuery("USC_UNIT_CREDIT_CODE", "*" + uscCode + "*"));
            ubuilder.minimumShouldMatch(1);
            boolMust.must(ubuilder);
        } else {
            if (!ObjectUtils.isEmpty(map.getString("USE_UNIT_CREDIT_CODE")) || !ObjectUtils.isEmpty(map.getString("useUnitCreditCode"))) {
                String uucc = !ValidationUtil.isEmpty(map.getString("USE_UNIT_CREDIT_CODE")) ? map.getString("USE_UNIT_CREDIT_CODE") : map.getString("useUnitCreditCode");
                String param = QueryParser.escape(uucc);
                param = param.contains("_") ? param.split("_")[0] : param;
                boolMust.must(QueryBuilders.matchQuery("USE_UNIT_CREDIT_CODE", param));
            }
            if (!ObjectUtils.isEmpty(map.getString("USC_UNIT_CREDIT_CODE"))) {
                String uscCode = QueryParser.escape(map.getString("USC_UNIT_CREDIT_CODE")).toLowerCase();
                boolMust.must(QueryBuilders.wildcardQuery("USC_UNIT_CREDIT_CODE", "*" + uscCode + "*"));
            }
        }
        // 监管码
        if (!ObjectUtils.isEmpty(map.getString("SUPERVISORY_CODE"))) {
            String supervisoryCode = map.getString("SUPERVISORY_CODE");
            boolMust.must(QueryBuilders.wildcardQuery("SUPERVISORY_CODE", "*" + supervisoryCode + "*"));
        }
        // 设备种类编码
        if (!ObjectUtils.isEmpty(map.getString("EQU_LIST_CODE"))) {
            boolMust.must(QueryBuilders.termsQuery("EQU_LIST_CODE", QueryParser.escape(map.getString("EQU_LIST_CODE"))));
        }
        // 设备类别
        if (!ObjectUtils.isEmpty(map.getString("EQU_CATEGORY_CODE"))) {
            boolMust.must(QueryBuilders.termQuery("EQU_CATEGORY_CODE", QueryParser.escape(map.getString("EQU_CATEGORY_CODE"))));
        }
        // 设备类别编码
        if (!ObjectUtils.isEmpty(map.getString("EQU_DEFINE_CODE"))) {
            boolMust.must(QueryBuilders.matchPhraseQuery("EQU_DEFINE_CODE", QueryParser.escape(map.getString("EQU_DEFINE_CODE"))));
        }
        // 设备代码模糊查询
        if (!ObjectUtils.isEmpty(map.getString(EQU_CODE))) {
            String test = QueryParser.escape(map.getString(EQU_CODE));
            boolMust.must(QueryBuilders.wildcardQuery(EQU_CODE, "*" + test.toLowerCase() + "*"));
        }
        // 单位内部编号模糊查询
        if (!ObjectUtils.isEmpty(map.getString("USE_INNER_CODE"))) {
            String test = QueryParser.escape(map.getString("USE_INNER_CODE"));
            boolMust.must(QueryBuilders.matchPhraseQuery("USE_INNER_CODE", test));
        }
        // 出厂编号/产品编码模糊查询
        if (!ObjectUtils.isEmpty(map.getString(BizCommonConstant.FACTORY_NUM))) {
            BoolQueryBuilder pBuilder = QueryBuilders.boolQuery();
            String test = QueryParser.escape(map.getString(BizCommonConstant.FACTORY_NUM));
            pBuilder.must(QueryBuilders.wildcardQuery(BizCommonConstant.FACTORY_NUM, "*" + test + "*"));
            boolMust.must(pBuilder);
        }
        builder.query(boolMust);
        builder.sort("REC_DATE", SortOrder.DESC);
        builder.from((pageNumber - 1) * size);
        builder.size(size);
        request.source(builder);
        List<JSONObject> list = new LinkedList<>();
        long totle = 0;
        if (log.isDebugEnabled()) {
            log.debug("查询es 的查询条件: {}", request);
        }
        try {
            SearchResponse response = restHighLevelClient.search(request, RequestOptions.DEFAULT);
            for (SearchHit hit : response.getHits().getHits()) {
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hit);
                JSONObject dto2 = jsonObject.getJSONObject("sourceAsMap");
                if (!ValidationUtil.isEmpty(dto2.get(EQU_STATE))) {
                    Integer integer = Integer.valueOf(dto2.get(EQU_STATE).toString());
                    String status = EquimentEnum.getName.get(integer);
                    dto2.put(EQU_STATE, status);
                }
                dto2.put("record", dto2.get(SEQUENCE_NBR));
                replaceNull2EmptyString(dto2);
                list.add(dto2);
            }
            // 填充地址
            fillAddress(list);
            totle = response.getInternalResponse().hits().getTotalHits().value;
            result.setRecords(list);
            result.setTotal(totle);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void replaceNull2EmptyString(JSONObject dto2) {
        dto2.forEach((k, v) -> {
            if (v == null || "null".equals(v)) {
                dto2.put(k, "");
            }
        });
    }


    private Function<JSONObject, Page<?>> handleByInspectType(String inspectType) {
        return queryParams -> {
            if (shouldUseNewMethod(inspectType)) {
                // 调用新方法处理特定inspectType的逻辑
                return handleSpecialInspectType(queryParams, inspectType);
            } else {
                // 默认使用原有查询方法
                return queryForEquipmentRegisterPage(queryParams);
            }
        };
    }

    private Page<?> handleSpecialInspectType(JSONObject queryParams, String inspectType) {
        int pageNumber = ObjectUtils.isEmpty(queryParams.getInteger("number")) ? 1 : queryParams.getInteger("number");
        int size = ObjectUtils.isEmpty(queryParams.getInteger("size")) ? 20 : queryParams.getInteger("size");
        Page<JSONObject> page = new Page<>(pageNumber, size);
        Map<String, Object> params = setFilterParamMap(queryParams);
        Page<JSONObject> equips = this.getBaseMapper().selectEquipList(page, params, getEquipInFlowing());
        equips.getRecords().forEach(item -> {
            if (!ValidationUtil.isEmpty(item.get(EQU_STATE))) {
                Integer integer = Integer.valueOf(item.get(EQU_STATE).toString());
                String status = EquimentEnum.getName.get(integer);
                item.put(EQU_STATE, status);
            }
            item.put("EQU_LIST", equipCategoryTypeHandler.handle(item.getString("EQU_LIST_CODE")));
            item.put("EQU_CATEGORY", equipCategoryTypeHandler.handle(item.getString("EQU_CATEGORY_CODE")));
            item.put("EQU_DEFINE", equipCategoryTypeHandler.handle(item.getString("EQU_DEFINE_CODE")));
            item.put("record", item.get(SEQUENCE_NBR));
            item.put("ADDRESS", this.removeSplitLine(item));
        });
        return equips;
    }

    private Map<String, Object> setFilterParamMap(JSONObject queryParams) {
        // 获取当前登录人单位类型
        JSONObject company = getCompanyType();
        Map<String, Object> params = new HashMap<>();
        String companyCode = company.getString("companyCode").contains("_") ? company.getString("companyCode").split("_")[1] : company.getString("companyCode");
        params.put("ME_UNIT_CREDIT_CODE", companyCode);
        // 设备类别
        if (!ObjectUtils.isEmpty(queryParams.getString("EQU_CATEGORY_CODE"))) {
            params.put("EQU_CATEGORY_CODE", queryParams.getString("EQU_CATEGORY_CODE"));
        }
        // 设备类别编码
        if (!ObjectUtils.isEmpty(queryParams.getString("EQU_DEFINE_CODE"))) {
            params.put("EQU_DEFINE_CODE", queryParams.getString("EQU_DEFINE_CODE"));
        }
        // 地市
        if (!ObjectUtils.isEmpty(queryParams.getString("CITY"))) {
            params.put("CITY", queryParams.getString("CITY"));
        }
        // 区县
        if (!ObjectUtils.isEmpty(queryParams.getString("COUNTY"))) {
            params.put("COUNTY", queryParams.getString("COUNTY"));
        }
        // 设备代码模糊查询
        if (!ObjectUtils.isEmpty(queryParams.getString(EQU_CODE))) {
            params.put(EQU_CODE, queryParams.getString(EQU_CODE));
        }
        // 单位内部编号模糊查询
        if (!ObjectUtils.isEmpty(queryParams.getString("USE_INNER_CODE"))) {
            params.put("USE_INNER_CODE", queryParams.getString("USE_INNER_CODE"));
        }
        return params;
    }

    private boolean shouldUseNewMethod(String inspectType) {
        JSONObject company = getCompanyType();
        String type = company.getString("companyType");
        return JYJCTypeEnum.DTJC.getCode().equals(inspectType) && "安装改造维修单位".equals(type);
    }

    /**
     * 设备过滤查询-显示未提交的设备、未使用的设备，流程中的设备不显示
     *
     * @param map 查询参数
     * @return 设备分页
     */
    public Page<JSONObject> queryForEquipmentRegisterPage(JSONObject map) {
        int pageNumber = ObjectUtils.isEmpty(map.getInteger("number")) ? 1 : map.getInteger("number");
        int size = ObjectUtils.isEmpty(map.getInteger("size")) ? 20 : map.getInteger("size");
        Page<JSONObject> result = new Page<>(pageNumber, size);
        SearchRequest request = new SearchRequest();
        request.indices("idx_biz_view_jg_all");
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.trackTotalHits(true);
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();

        // 获取当前登录人单位类型
        JSONObject company = getCompanyType();
        if (ValidationUtil.isEmpty(company)) {
            result.setRecords(new ArrayList<>());
            result.setTotal(0);
            return result;
        }
        String companyCode = company.getString("companyCode").contains("_") ? company.getString("companyCode").split("_")[1] : company.getString("companyCode");
        String type = company.getString("companyType");
        // 按照身份过滤
        setFilterByIndefinite(map, type, companyCode, boolMust);
        // 设备种类编码
        if (!ObjectUtils.isEmpty(map.getString("EQU_LIST_CODE"))) {
            boolMust.must(QueryBuilders.termQuery("EQU_LIST_CODE", QueryParser.escape(map.getString("EQU_LIST_CODE"))));
        }
        // 设备类别
        if (!ObjectUtils.isEmpty(map.getString("EQU_CATEGORY_CODE"))) {
            boolMust.must(QueryBuilders.termQuery("EQU_CATEGORY_CODE", QueryParser.escape(map.getString("EQU_CATEGORY_CODE"))));
        }
        // 设备类别编码
        if (!ObjectUtils.isEmpty(map.getString("EQU_DEFINE_CODE"))) {
            boolMust.must(QueryBuilders.termQuery("EQU_DEFINE_CODE.keyword", QueryParser.escape(map.getString("EQU_DEFINE_CODE"))));
        }
        String inspectionType = map.getString("inspectionType");
        // 非首次检验时，需要按照选择的地市区县过滤；首检的地市只作为报检规则的匹配条件
        if (!JYJCBusinessTypeEnum.SCJY.getCode().equals(inspectionType)) {
            // 地市
            if (!ObjectUtils.isEmpty(map.getString("CITY"))) {
                boolMust.must(QueryBuilders.wildcardQuery("USE_PLACE_CODE", "*" + map.getString("CITY") + "*"));
            }
            // 区县筛选设置，雁塔时去掉高新数据；高新、经开、西咸时按照属地监管部门过滤
            this.setSpecificallyFilter(boolMust, map);
        }
        // 设备代码模糊查询
        if (!ObjectUtils.isEmpty(map.getString(EQU_CODE))) {
            String test = QueryParser.escape(map.getString(EQU_CODE));
            boolMust.must(QueryBuilders.wildcardQuery(EQU_CODE, "*" + test.toLowerCase() + "*"));
        }

        // 单位内部编号模糊查询
        if (!ObjectUtils.isEmpty(map.getString("USE_INNER_CODE"))) {
            String test = QueryParser.escape(map.getString("USE_INNER_CODE"));
            boolMust.must(QueryBuilders.matchPhraseQuery("USE_INNER_CODE", test));
        }
        // 大型游乐设施时按照设备分类过滤
        if (!ObjectUtils.isEmpty(map.getString("equipTag1")) && EquipmentClassifityEnum.YLSS.getCode().equals(map.getString("EQU_LIST_CODE"))) {
            // 筛选时取本级及空的
            String equipTag1 = map.getString("equipTag1");
            BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
            orBuilder.should(QueryBuilders.termQuery("tag1.keyword", equipTag1));
            orBuilder.should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery("tag1")));
            orBuilder.should(QueryBuilders.boolQuery().must(QueryBuilders.matchPhraseQuery("tag1", "")));
            orBuilder.minimumShouldMatch(1);
            boolMust.must(orBuilder);
        }
        // 固定式压力容器按照是否球罐过滤
        if (!ObjectUtils.isEmpty(map.getString("equipTag1")) && BizCommonConstant.EQU_CATEGORY_CODE_GDYLRQ.equals(map.getString("EQU_CATEGORY_CODE"))) {
            boolMust.must(QueryBuilders.termQuery("whetherSphericalTank.keyword", QueryParser.escape(map.getString("equipTag1"))));
        }
        this.setFilterOfInFlowing(boolMust, map.getString("EQU_LIST_CODE"), map.getString("inspectionType"), map.getString("EQU_CATEGORY_CODE"));
        builder.query(boolMust);
        builder.sort("REC_DATE", SortOrder.DESC);
        builder.from((pageNumber - 1) * size);
        builder.size(size);
        request.source(builder);
        List<JSONObject> list = new LinkedList<>();
        long total = 0;
        if (log.isInfoEnabled()) {
            log.info("查询es 的查询条件: {}", request);
        }
        try {
            SearchResponse response = restHighLevelClient.search(request, RequestOptions.DEFAULT);
            for (SearchHit hit : response.getHits().getHits()) {
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hit);
                JSONObject dto2 = jsonObject.getJSONObject("sourceAsMap");
                if (!ValidationUtil.isEmpty(dto2.get(EQU_STATE))) {
                    Integer integer = Integer.valueOf(dto2.get(EQU_STATE).toString());
                    String status = EquimentEnum.getName.get(integer);
                    dto2.put(EQU_STATE, status);
                }
                dto2.put("record", dto2.get(SEQUENCE_NBR));
                replaceNull2EmptyString(dto2);
                list.add(dto2);
            }
            // 填充地址
            fillAddress(list);
            fillTechParamForGl(map.getString("EQU_CATEGORY_CODE"), list);
            total = response.getInternalResponse().hits().getTotalHits().value;
            result.setRecords(list);
            result.setTotal(total);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void setSpecificallyFilter(BoolQueryBuilder boolMust, JSONObject map) {
        if (ObjectUtils.isEmpty(map.getString("COUNTY"))) {
            return;
        }
        // 前端需要此字段，无值时为none, 后端在空标识时不使用此字段作为过滤条件
        if (BizCommonConstant.NONE.equals(map.getString("COUNTY"))) {
            return;
        }
        // 设备种类
        String equListCode = map.getString("EQU_LIST_CODE");
        // 机电类才按照属地+区县过滤，其他还是按照属地过滤（区县里没特殊的高新、经开、西咸）
        if (JD_EQU_LIST_CODES.contains(equListCode)) {
            // 雁塔时去掉高新数据
            if (String.valueOf(BizCommonConstant.REGION_CODE_YT).equals(map.getString("COUNTY"))) {
                // 区县筛选
                boolMust.must(QueryBuilders.wildcardQuery("USE_PLACE_CODE", "*" + map.getString("COUNTY") + "*"));
                // 按照属地去掉高新数据、经开、西咸
                boolMust.mustNot(QueryBuilders.wildcardQuery("ORG_BRANCH_CODE.keyword", QueryParser.escape(SpeRegionInfoEnum.GX.getOrgCode()) + "*"));
                boolMust.mustNot(QueryBuilders.wildcardQuery("ORG_BRANCH_CODE.keyword", QueryParser.escape(SpeRegionInfoEnum.JK.getOrgCode()) + "*"));
                boolMust.mustNot(QueryBuilders.wildcardQuery("ORG_BRANCH_CODE.keyword", QueryParser.escape(SpeRegionInfoEnum.XX.getOrgCode()) + "*"));
                return;
            }
            // 高新、经开、西咸时按照属地监管部门过滤
            if (Arrays.stream(SpeRegionInfoEnum.values()).sequential().anyMatch(r -> r.getCode().equals(map.getIntValue("COUNTY")))) {
                boolMust.must(QueryBuilders.wildcardQuery("ORG_BRANCH_CODE.keyword", QueryParser.escape(Objects.requireNonNull(SpeRegionInfoEnum.getByCode(map.getInteger("COUNTY"))).getOrgCode()) + "*"));
                return;
            }
            // 其他：区县过滤+去掉分出去的经开、西咸数据
            boolMust.must(QueryBuilders.wildcardQuery("USE_PLACE_CODE", "*" + map.getString("COUNTY") + "*"));
            boolMust.mustNot(QueryBuilders.wildcardQuery("ORG_BRANCH_CODE.keyword", QueryParser.escape(SpeRegionInfoEnum.JK.getOrgCode()) + "*"));
            boolMust.mustNot(QueryBuilders.wildcardQuery("ORG_BRANCH_CODE.keyword", QueryParser.escape(SpeRegionInfoEnum.XX.getOrgCode()) + "*"));
        } else {
            boolMust.must(QueryBuilders.wildcardQuery("USE_PLACE_CODE", "*" + map.getString("COUNTY") + "*"));
        }
    }

    private void fillTechParamForGl(String equCategoryCode, List<JSONObject> list) {
        if (BizCommonConstant.YLRQ_GL_CY.equals(equCategoryCode)) {
            for (JSONObject jsonObject : list) {
                String record = jsonObject.getString(SEQUENCE_NBR);
                EquipTechParamBoiler paramBoiler = equipTechParamBoilerMapper.queryTechParamInUse(record);
                jsonObject.put(BizCommonConstant.TECH_PARAM1, paramBoiler != null ? paramBoiler.getRatedEvaporationCapacityThermalPower() : "0");
                jsonObject.put(BizCommonConstant.TECH_PARAM2, paramBoiler != null ? paramBoiler.getRatedWorkingPressure() : "0");
            }
        }
    }

    private void setFilterByIndefinite(JSONObject map, String type, String companyCode, BoolQueryBuilder boolMust) {
        // 根据当前登录用户类型及管辖机构筛选条件添加对应参数
        if (!ValidationUtil.isEmpty(type) && type.contains("使用单位")) {
            boolMust.must(QueryBuilders.termQuery("USE_UNIT_CREDIT_CODE.keyword", QueryParser.escape(companyCode)));
        }
        if (!ValidationUtil.isEmpty(type) && type.contains("安装改造维修单位")) {
            BoolQueryBuilder builder = QueryBuilders.boolQuery();
            builder.must(QueryBuilders.wildcardQuery("USC_UNIT_CREDIT_CODE", "*" + QueryParser.escape(companyCode.toLowerCase()) + "*"));
            String useUnitCode = getUseUnitCreditBySeq(map.getString("useUnitCreditCode"));
            builder.must(QueryBuilders.termQuery("USE_UNIT_CREDIT_CODE.keyword", QueryParser.escape(useUnitCode)));
            boolMust.must(builder);
        }
        if (!ValidationUtil.isEmpty(type) && type.contains("个人主体")) {
            boolMust.must(QueryBuilders.termQuery("USE_UNIT_CREDIT_CODE.keyword", QueryParser.escape(companyCode)));
        }
    }

    private String getUseUnitCreditBySeq(String seq) {
        TzBaseEnterpriseInfo enterpriseInfo = baseEnterpriseInfoMapper.selectOne(new LambdaQueryWrapper<TzBaseEnterpriseInfo>()
                .eq(com.yeejoin.amos.boot.biz.common.entity.BaseEntity::getSequenceNbr, seq)
                .select(com.yeejoin.amos.boot.biz.common.entity.BaseEntity::getSequenceNbr, TzBaseEnterpriseInfo::getUseUnitCode));
        return enterpriseInfo.getUseUnitCode();
    }


    /**
     * 过滤条件去掉流程中的设备,
     *
     * @param boolMust 条件
     */
    private void setFilterOfInFlowing(BoolQueryBuilder boolMust, String equListCode, String inspectionType, String equCategoryCode) {
        Set<String> records = this.getEquipInFlowing();
        if (records != null && !records.isEmpty()) {
            boolMust.mustNot(QueryBuilders.termsQuery("SEQUENCE_NBR.keyword", records));
        }
        // 流动时起重机械及厂车可直接做首检
        if (("5000".equals(equListCode) || "4400".equals(equCategoryCode)) && JYJCBusinessTypeEnum.SCJY.getCode().equals(inspectionType)) {
            // 5000/4400 且是首检，或是委托检验，都不需要进入管理
            boolMust.must(QueryBuilders.termQuery("IS_INTO_MANAGEMENT", false));
        } else {
            // 历史无证设备可做检验
            boolMust.must(QueryBuilders.boolQuery()
                    .should(QueryBuilders.termQuery("IS_INTO_MANAGEMENT", true))
                    .should(QueryBuilders.prefixQuery("DATA_SOURCE", "jg_his_black"))
                    .minimumShouldMatch(1));
        }
        boolMust.must(QueryBuilders.existsQuery("IS_INTO_MANAGEMENT"));
    }

    private Set<String> getEquipInFlowing() {
        return this.getBaseMapper().queryRecordInFlowing();
    }

    private void fillAddress(List<JSONObject> list) {
        for (JSONObject item : list) {
            item.put("ADDRESS", this.removeSplitLine(item));
        }
    }

    private Object removeSplitLine(JSONObject item) {
        String fullAddress = item.getString("USE_PLACE") + item.getString("ADDRESS");
        fullAddress = fullAddress.replace("/", "").replace("null", "");
        return fullAddress;
    }

    public List<TzBaseEnterpriseInfoDto> getInspectionUnitListForWorkbench(String openBizType) {
        return commonService.getInspectionUnitList(openBizType);
    }

    public List<DictionarieModel> inspectTypeListByBizType(String bizType) {
        return getDictionarieModels(bizType);
    }

    public IPage<IdxBizJgProjectContraption> getJgProjectContraptionPage(ContraptionQueryParams queryParams, Page<IdxBizJgProjectContraption> page, String companyCode) {
        // 兼容个人业务
        if (companyCode.contains("_")) {
            companyCode = companyCode.split("_")[1];
        }
        // 前端需要此字段无值时为none, 后端在空标识时设置为null,
        if (BizCommonConstant.NONE.equals(queryParams.getCounty())) {
            queryParams.setCounty(null);
        }
        // 定期检验，查询当前使用单位，工业管道: 查询当前使用单位下已纳管且有使用登记证的装置，且非流程中的 ；公用管道、长输管道:已纳管且做过检验的，且非流程中的
        return idxBizJgProjectContraptionMapper.queryJgProjectContraptionPage(page, queryParams, companyCode);
    }


    /**
     * 查询指定装置下的装置基本信息、施工/使用信息、管道信息（前缀装置列表已进行过滤，故不进行状态的过滤）--报检发起使用
     *
     * @param projectContraptionSeq 装置id
     * @return 装置的详情
     */
    public Map<String, Object> getDeviceListByProjectContraption(String projectContraptionSeq) {
        IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionMapper.selectById(projectContraptionSeq);
        Map<String, Object> re = new HashMap<>();
        List<Map<String, Object>> equList = this.getBaseMapper().selectPieLineListByProjectId(projectContraptionSeq);
        re.put("equip", equList);
        re.put("projectContraption", projectContraption.getProjectContraption());
        re.put("projectContraptionId", projectContraptionSeq);
        re.put("projectContraptionNo", projectContraption.getProjectContraptionNo());
        re.put("pipelineLength", projectContraption.getPipelineLength());
        re.put("useRegistrationCode", projectContraption.getUseRegistrationCode());
        this.setInstallAddress(projectContraption, re);
        this.setUseAddress(projectContraption, re);
        return re;
    }

    /**
     * 使用地点-使用登记完成后回把使用登记的地点信息写到装置表。定期检验时显示
     *
     * @param projectContraption 装置
     * @param re                 返回结果：增加使用地点（工业管道是使用登记时的地址）；公用、长输管道是安装地址（无使用登记证）
     */
    private void setUseAddress(IdxBizJgProjectContraption projectContraption, Map<String, Object> re) {
        re.put("useAddress", getDetailAddress(projectContraption));
    }

    /**
     * 查询指定报检单据下的装置管道信息-----报检详情使用与getDeviceListByProjectContraption区别，指定了管道
     *
     * @param applicationModel 报检单据信息
     * @return 装置的详情
     */
    public JSONObject getDeviceListByProjectContraption2(JyjcInspectionApplicationModel applicationModel) {
        IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionMapper.selectById(applicationModel.getProjectContraptionId());
        List<Map<String, Object>> equList = getPipelines(applicationModel);
        JSONObject jsonObject = new JSONObject();
        return setPieLineInfo(applicationModel, projectContraption, jsonObject, equList);
    }

    public List<Map<String, Object>> getPipelines(JyjcInspectionApplicationModel applicationModel) {
        List<JyjcInspectionApplicationEquipModel> applicationEquipModels = applicationEquipService.listApplicationEquipByApplicationSeq(applicationModel.getSequenceNbr());
        List<String> records = applicationEquipModels.stream().map(JyjcInspectionApplicationEquipModel::getEquipUnicode).collect(Collectors.toList());
        return this.getBaseMapper().selectPieLineListOfInspect(records);
    }

    public List<Map<String, Object>> getPipelines(JyjcInspectionApplication application) {
        List<JyjcInspectionApplicationEquipModel> applicationEquipModels = applicationEquipService.listApplicationEquipByApplicationSeq(application.getSequenceNbr());
        List<String> records = applicationEquipModels.stream().map(JyjcInspectionApplicationEquipModel::getEquipUnicode).collect(Collectors.toList());
        return this.getBaseMapper().selectPieLineListOfInspect(records);
    }

    @NotNull
    private JSONObject setPieLineInfo(JyjcInspectionApplicationModel applicationModel, IdxBizJgProjectContraption projectContraption, JSONObject jsonObject, List<Map<String, Object>> equList) {
        jsonObject.put("equip", equList);
        jsonObject.put("projectContraption", projectContraption.getProjectContraption());
        jsonObject.put("projectContraptionId", applicationModel.getProjectContraptionId());
        jsonObject.put("projectContraptionNo", projectContraption.getProjectContraptionNo());
        jsonObject.put("pipelineLength", calTotalLength(equList));
        jsonObject.put("equListName", projectContraption.getEquListName());
        jsonObject.put("equCategoryName", projectContraption.getEquCategoryName());
        jsonObject.put("equDefineName", projectContraption.getEquDefineName());
        jsonObject.put("useRegistrationCode", projectContraption.getUseRegistrationCode());
        this.setInstallAddress(projectContraption, jsonObject);
        this.setUseAddress(projectContraption, jsonObject);
        return jsonObject;
    }

    private void setInstallAddress(IdxBizJgProjectContraption projectContraption, Map<String, Object> re) {
        re.put("installAddress", getDetailAddress(projectContraption));
    }

    /**
     * 安装地址：安装告知完成后，此字段为安装地址
     *
     * @param projectContraption 装置
     * @param jsonObject         增加安装地址
     */
    private void setInstallAddress(IdxBizJgProjectContraption projectContraption, JSONObject jsonObject) {
        jsonObject.put("installAddress", getDetailAddress(projectContraption));
    }

    /**
     * 管道报检结果-管道详情页签-数据缓存---与getDeviceListByProjectContraption2区别，汇总表内不包含检验信息
     *
     * @param applicationModel 申请单
     * @return 无检验信息的汇总管道-检验结果页面专用
     */
    public JSONObject getDeviceListByProjectContraption3(JyjcInspectionApplicationModel applicationModel) {
        JSONObject jsonObject = new JSONObject();
        IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionMapper.selectById(applicationModel.getProjectContraptionId());
        List<JyjcInspectionApplicationEquipModel> applicationEquipModels = applicationEquipService.listApplicationEquipByApplicationSeq(applicationModel.getSequenceNbr());
        List<String> records = applicationEquipModels.stream().map(JyjcInspectionApplicationEquipModel::getEquipUnicode).collect(Collectors.toList());
        List<Map<String, Object>> equList = this.getBaseMapper().selectPieLineListOfNoInspectInfo(records);
        return setPieLineInfo(applicationModel, projectContraption, jsonObject, equList);
    }

    public static String calTotalLength(List<Map<String, Object>> equList) {
        double pipeLengthSum = equList.stream().map(r -> r.get("pipeLength")).filter(Objects::nonNull).mapToDouble(l -> Double.parseDouble(String.valueOf(l))).sum();
        BigDecimal pipeLengthSumBig = new BigDecimal(String.valueOf(pipeLengthSum)).setScale(3, RoundingMode.HALF_UP);
        return pipeLengthSumBig.toPlainString();
    }


    private String trimIfNull(String str) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        return str.trim();
    }

    private String getDetailAddress(IdxBizJgProjectConstruction construction) {
        return trimIfNull(construction.getProvinceName()) + trimIfNull(construction.getCityName()) + trimIfNull(construction.getCountyName()) + trimIfNull(construction.getStreetName() + trimIfNull(construction.getAddress()));
    }

    private String getDetailAddress(IdxBizJgProjectContraption projectContraption) {
        return trimIfNull(projectContraption.getProvinceName()) + trimIfNull(projectContraption.getCityName()) + trimIfNull(projectContraption.getCountyName()) + trimIfNull(projectContraption.getStreetName() + trimIfNull(projectContraption.getAddress()));
    }

    /**
     * 查询单位下的所有工程装置（父ID为空）的数据
     *
     * @param useUnitCreditCode
     * @param page
     * @return
     */
    public IPage<IdxBizJgProjectContraption> getJgAllProConPage(String useUnitCreditCode, String projectContraption, Page<IdxBizJgProjectContraption> page) {
        // 兼容个人业务
        if (useUnitCreditCode.contains("_")) {
            useUnitCreditCode = useUnitCreditCode.split("_")[1];
        }
        // 查询已纳管且使用登记证编号不为空的装置
        LambdaQueryWrapper<IdxBizJgProjectContraption> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizJgProjectContraption::getUseUnitCreditCode, useUnitCreditCode);
        wrapper.eq(StringUtils.isNotBlank(projectContraption), IdxBizJgProjectContraption::getProjectContraption, projectContraption);
        wrapper.eq(IdxBizJgProjectContraption::getIsFirstMerge, false);
        wrapper.isNull(IdxBizJgProjectContraption::getProjectContraptionParentId);
        wrapper.isNotNull(IdxBizJgProjectContraption::getUseRegistrationCode);
        wrapper.ne(IdxBizJgProjectContraption::getUseRegistrationCode, "");
        wrapper.last("order by create_date desc");
        IPage<IdxBizJgProjectContraption> projectContraptionPage = jgProjectContraptionMapper.selectPage(page, wrapper);
        projectContraptionPage.getRecords().forEach(pro -> pro.setDataQualityScore(commonService.castDataQualityScore2Name(pro.getDataQualityScore(), pro.getIsIntoManagement())));
        return projectContraptionPage;
    }

    public Page<?> queryForEquipmentRegisterPageDispatch(JSONObject jsonObject) {
        return handleByInspectType(jsonObject.getString("inspectionType")).apply(jsonObject);
    }

    public Object getRegion(String level, String parentId) {
        List<RegionModel> regionModels = FeignUtil.remoteCall(() -> jgFeignClient.getRegion(level, parentId));
        // 西安时增加：西咸、经开、高新；雁塔调整为雁塔（除去高新）
        if (BizCommonConstant.REGION_CODE_XIAN.equals(parentId)) {
            for (SpeRegionInfoEnum infoEnum : SpeRegionInfoEnum.values()) {
                RegionModel regionModel = new RegionModel();
                regionModel.setRegionCode(infoEnum.getCode());
                regionModel.setRegionName(infoEnum.getName());
                regionModels.add(regionModel);
            }
            regionModels.forEach(regionModel -> {
                if (Objects.equals(regionModel.getRegionCode(), BizCommonConstant.REGION_CODE_YT)) {
                    regionModel.setRegionName("雁塔区(除高新)");
                }
            });
        } else if (BizCommonConstant.REGION_CODE_XY.equals(parentId)) {
            // 咸阳时增加西咸新区下拉
            RegionModel regionModel = new RegionModel();
            regionModel.setRegionCode(SpeRegionInfoEnum.XX.getCode());
            regionModel.setRegionName(SpeRegionInfoEnum.XX.getName());
            regionModels.add(regionModel);
        }
        return regionModels;
    }

    public String genDocPath(String appSeq) {
        StopWatch watch = new StopWatch();
        watch.start();
        DocGenerationRequest docGenerationRequest = defaultDocGenerateAdapter.prepareRequest(appSeq);
        DocGenerator docGenerator = docGeneratorFactory.getGenerator(docGenerationRequest);
        String path = docGenerator.generate(appSeq);
        watch.stop();
        log.info("生成报检申请表耗时：{}秒", watch.getTotalTimeSeconds());
        return path;
    }
}