<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output encoding="utf-8"/>
<xsl:template match="/">
<html>
 <head> 
  <title>
  	智能巡检系统
  </title> 
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no" />
 </head> 
 <body>
   <h2></h2>
    <table border="0" width="100%" style="border-collapse:separate; border-spacing:0px 15px;">
    	<caption><h1>任务安排表</h1></caption>
      <tr>
        <th width="20%" style='text-align:right'><font face="Simsun" size="2">任务标题：</font></th>
        <th width="80%" style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="taskInfo/taskInfo/title"/></font></th>
      </tr>
	  <tr>
        <th width="20%" style='text-align:right'><font face="Simsun" size="2">发起人：</font></th>
        <th width="80%" style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="taskInfo/taskInfo/publisherName"/></font></th>
      </tr>
	  <tr>
        <th width="20%" style='text-align:right'><font face="Simsun"  size="2">执行人：</font></th>
        <th width="80%" style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="taskInfo/taskInfo/executor"/></font></th>
      </tr>
	  <tr>
        <th width="20%" style='text-align:right'><font face="Simsun" size="2">状态：</font></th>
        <th width="80%" style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="taskInfo/taskInfo/status"/></font></th>
      </tr>
	  <tr>
        <th width="20%" style='text-align:right'><font face="Simsun" size="2">要求完成时间：</font></th>
        <th width="80%" style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="taskInfo/taskInfo/finishTime"/></font></th>
      </tr>
	  <tr>
        <th width="20%" style='text-align:right'><font face="Simsun" size="2">任务内容：</font></th>
        <th width="80%" style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="taskInfo/taskInfo/remark"/></font></th>
      </tr>
    </table>
	<xsl:for-each select="taskInfo/feedback/TaskFeedbacks">
	<hr />
	<table border="0">
      <tr>
        <th style='text-align:left'>
        	<xsl:attribute name="colspan">
			    	<xsl:value-of select="count(//string)" />
			 </xsl:attribute>
			 <font face="Simsun" size="2"><xsl:value-of select="message"/></font>
        </th>
      </tr>
	   <tr>
	   <xsl:for-each select="feedbackPics/string">
        <th >
        	<img  style="width:200px; height: 270px">
	        	<xsl:attribute name="src">
			    	<xsl:value-of select="." />
			  	</xsl:attribute>
		  	</img>
        </th>
		</xsl:for-each>
      </tr>
       <tr>
        <th style='text-align:left'>
        	<xsl:attribute name="colspan">
			    	<xsl:value-of select="count(//string)" />
			 </xsl:attribute>
			 <font face="Simsun" size="2">
        	<xsl:value-of select="userName"/></font>&#8195;&#8195;
        	<font face="Simsun" size="2"><xsl:value-of select="feedbackTime"/>
        	</font>
        </th>
      </tr>
    </table>
	 </xsl:for-each>
	  </body>
</html>
</xsl:template>
</xsl:stylesheet>