package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.IBaseChangeData;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 安全追溯-设计信息表
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_design_info")
@Group(value = "idx_biz_jg_design_info")
public class IdxBizJgDesignInfo extends TzsBaseEntity implements IBaseChangeData {

    
    
    /**
     *
     */
	@TableField("\"RECORD\"")
    private String record;

    /**
     *
     */
	@TableField("\"INSTANCE_ID\"")
    private String instanceId;

    /**
     *
     */
	@TableField("\"STATUS\"")
    private String status;

    /**
     *
     */
	@TableField("\"DESIGN_UNIT_CREDIT_CODE\"")
    @FieldDisplayDefine(value = "设计单位统一社会信用代码")
    private String designUnitCreditCode;

    /**
     *
     */
	@TableField("\"DESIGN_UNIT_NAME\"")
    @FieldDisplayDefine(value = "设计单位名称")
    private String designUnitName;

    /**
     *
     */
	@TableField("\"DESIGN_LICENSE_NUM\"")
    @FieldDisplayDefine(value = "设计许可编号")
    private String designLicenseNum;

    /**
     *
     */
	@TableField("\"DESIGN_USE_DATE\"")
    @FieldDisplayDefine(value = "设计使用年限")
    private String designUseDate;

    /**
     *
     */
	@TableField("\"DESIGN_DATE\"")
    @FieldDisplayDefine(value = "设计日期")
    private Date designDate;

    /**
     *
     */
	@TableField("\"DRAWING_DO\"")
    @FieldDisplayDefine(value = "总图图号")
    private String drawingDo;

    /**
     *
     */
	@TableField("\"DESIGN_DOC\"")
    @FieldDisplayDefine(value = "设计文件", type = JSON.class)
    private String designDoc;

    /**
     *
     */
	@TableField("\"APPRAISAL_UNIT\"")
    @FieldDisplayDefine(value = "设计文件鉴定单位")
    private String appraisalUnit;

    /**
     *
     */
	@TableField("\"APPRAISAL_DATE\"")
    @FieldDisplayDefine(value = "设计文件鉴定日期")
    private String appraisalDate;

    /**
     *
     */
	@TableField("\"DESIGN_STANDARD\"")
    @FieldDisplayDefine(value = "设计规范", type = JSON.class)
    private String designStandard;

    /**
     *其他附件
     */
	@TableField("\"OTHER_ACCESSORIES_DES\"")
    @FieldDisplayDefine(value = "其他附件", type = JSON.class)
    private String otherAccessoriesDes;

    /**
     * 资料是否完整齐全：1-齐全；2-不齐全【历史无证设备需要】
     */
    @TableField("\"DESIGN_IS_COMPLETE\"")
    @FieldDisplayDefine(value = "设计资料是否完整齐全", typeHandler = "isCompleteTypeHandler")
    private String designIsComplete;

    /**
     * 延期使用年限日期
     */
    @TableField("\"DELAY_SERVICE_LIFE_DATE\"")
    private String delayServiceLifeDate;

    /**
     * 超设计使用变更登记次数(默认0，最多2次)
     */
    @TableField("\"OVER_DESIGN_REG_NUM\"")
    private Integer overDesignRegNum;
}
