package com.yeejoin.amos.api.householdapi.Utils;

import cn.hutool.Hutool;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.qiniu.util.Json;
import com.yeejoin.amos.api.householdapi.face.model.HouseholdPvApiDto;
import com.yeejoin.amos.api.householdapi.face.model.HouseholdPvProducerInfoDto;
import com.yeejoin.amos.api.householdapi.face.orm.entity.HouseholdPvProducerInfo;
import com.yeejoin.amos.api.householdapi.face.service.impl.HouseholdPvApiServiceImpl;
import com.yeejoin.amos.api.householdapi.face.service.impl.HouseholdPvProducerInfoServiceImpl;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.cache.Redis;

import java.util.*;

@Component
public class HouseholdPvUtils {
    @Autowired
    private HouseholdPvProducerInfoServiceImpl householdPvProducerInfoServiceImpl;
    @Autowired
    private HouseholdPvApiServiceImpl householdPvApiServiceImpl;

    @Autowired
    InfluxDbConnection influxDbConnection;

    private final static String API_REDIS_PREFIX = "HOUSEHOLD_API_CACHE_" +
            "";

    /**
     * @param code 厂商code
     * @return HashMap<String, Object>   发送请求前的准备 准备header信息
     * @deprecated 根据厂商编码获取厂商的hearer
     */
    public HashMap<String, Object> getHeaderByProducerCode(String code) {
        HashMap<String, Object> hashMap = new HashMap<>();
        HashMap<String, String> hashMaphead = new HashMap<>();
        HouseholdPvProducerInfo householdPvProducerInfo = this.householdPvProducerInfoServiceImpl.queryForHouseholdPvProducerInfoByCode(code);
        String url = householdPvProducerInfo.getProdcerUrl() + householdPvProducerInfo.getTokenUrl();
        hashMap.put("apiurl", householdPvProducerInfo.getProdcerUrl());
        if (PVProducerInfoEnum.GDW.getCode().equals(code)) {
            HashMap<String, String> map = new HashMap<>();
            map.put("account", householdPvProducerInfo.getProdcerAccount());
            map.put("pwd", householdPvProducerInfo.getProdcerPassword());
            String body = JSON.toJSONString(map);
            String response = HttpUtil.createPost(url).body(body).execute().body();
            JSONObject jsonObject = JSON.parseObject(response);
            if (jsonObject.get("data") != null) {
                JSONObject jsonObject1 = (JSONObject) jsonObject.get("data");
                hashMaphead.put("token", (String) jsonObject1.get("token"));
                hashMap.put("header", hashMaphead);
            }
        } else if (PVProducerInfoEnum.SH.getCode().equals(code)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("accountName", householdPvProducerInfo.getProdcerAccount());
            map.put("appId", householdPvProducerInfo.getProdcerAppid());
            map.put("appSecret", householdPvProducerInfo.getProdcerAppsecret());
            map.put("corporationId", householdPvProducerInfo.getCorporationId());
            map.put("accountType", 2);
            String body = JSON.toJSONString(map);
            String response = HttpUtil.createPost(url).body(body).execute().body();
            JSONObject jsonObject = JSON.parseObject(response);
            hashMaphead.put("Authorization", (String) jsonObject.get("data"));
            hashMap.put("header", hashMaphead);
        } else if (PVProducerInfoEnum.JLY.getCode().equals(code)) {
            hashMaphead.put("Content-type", "application/json;charset=UTF-8");
            hashMaphead.put("Authorization", "API " + householdPvProducerInfo.getProdcerAppid());
            hashMaphead.put("Content-MD5", null);
            hashMaphead.put("Date", GoLangHeaderUtils.getGMTTime());
            hashMap.put("header", hashMaphead);
            hashMap.put("appsecret", householdPvProducerInfo.getProdcerAppsecret());
        }
        return hashMap;
    }

    /**
     * @param seq apiId 数据库中维护的的apiId
     * @return String 请求返回的response字符串
     */
    public String gerResponseByAPiID(Long seq) {
        HouseholdPvApiDto householdPvApiDto = this.householdPvApiServiceImpl.queryBySeq(seq);
        HashMap<String, Object> producerInfo = this.getHeaderByProducerCode(householdPvApiDto.getProducerId());
        HashMap<String, String> headMap = (HashMap<String, String>) producerInfo.get("header");
        if (PVProducerInfoEnum.JLY.getCode().equals(householdPvApiDto.getProducerId())) {
            String contentMD5 = GoLangHeaderUtils.getDigest(householdPvApiDto.getParamInfo());
            String param = "POST" + "\n" + contentMD5 + "\n" + "application/json" + "\n" + headMap.get("Date") + "\n" + householdPvApiDto.getApiUrl();
            String sign = "";
            try {
                sign = GoLangHeaderUtils.HmacSHA1Encrypt(param, (String) producerInfo.get("appsecret"));
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
            headMap.put("Content-MD5", contentMD5);
            headMap.put("Authorization", headMap.get("Authorization") + ":" + sign);
        }
        String respone = "";
        if (householdPvApiDto.getRequestMethod().equals("POST")) {
            respone = HttpUtil.createPost(producerInfo.get("apiurl") + householdPvApiDto.getApiUrl()).headerMap(headMap, false).
                    body(householdPvApiDto.getParamInfo()).execute().body();
        }
        if (householdPvApiDto.getRequestMethod().equals("GET")) {
            respone = HttpUtil.createGet(producerInfo.get("apiurl") + householdPvApiDto.getApiUrl()).headerMap(headMap, true).
                    body(householdPvApiDto.getParamInfo()).execute().body();
        }
        JSONArray jsonArray = handlerResponseByResultResolverule(householdPvApiDto.getResultResolveRule(), respone);
        handleResponseAndCacheData(String.valueOf(seq), householdPvApiDto.getCacheField(), jsonArray,householdPvApiDto.getMeasurement());
        return respone;
    }

    /**
     * @param resultResovle 请求返回的解析规则 来源与数据库
     * @param response      请求返回的字符串
     * @return 解析后的数据
     */
    public JSONArray handlerResponseByResultResolverule(String resultResovle, String response) {
        String[] rules = resultResovle.split(",");
        JSONObject jsonObject = JSONObject.parseObject(response);
        JSONArray jsonArray = new JSONArray();
        if (rules.length > 0) {
            for (int i = 0; i < rules.length; i++) {
                try {
                    jsonObject = (JSONObject) jsonObject.get(rules[i]);
                    if (jsonObject == null) {
                        jsonArray = (JSONArray) jsonObject.get(rules[i]);
                    }
                } catch (Exception exception) {
                    jsonArray = (JSONArray) jsonObject.get(rules[i]);
                }
            }
        }
        return jsonArray;
    }

    /**
     * @param seq         apiID
     * @param cacheField  要缓存的字段
     * @param jsonArray   处理后的数据请求
     * @param measurement 要在influxdb中存储的数
     * @describe 该方法用于缓存需要缓存的字段 且将需要入库的数据进行入库
     */
    public void handleResponseAndCacheData(String seq, String cacheField, JSONArray jsonArray, String measurement) {
        String apiID = API_REDIS_PREFIX + seq;
        List list = new ArrayList();
        List saveList = new ArrayList();
        if (jsonArray.size() > 0) {
            for (Object o : jsonArray) {
                Map<String, Object> maps1 = (Map<String, Object>) o;
                if (cacheField != null) {
                    list.add(maps1.get(cacheField));
                }
                Map<String, String> maps2 = new HashMap<>();
                maps2.put("key", UUID.randomUUID().toString());
                if (measurement != null) {
                    influxDbConnection.insert(measurement, maps2, maps1);
                }

            }
        }
        saveList = Redis.getRedisTemplate().opsForList().range(apiID, 0, -1);
        if (saveList.size() == 0) {
            Redis.getRedisTemplate().opsForList().leftPushAll(apiID, list);
        }
        saveList = Redis.getRedisTemplate().opsForList().range(apiID,0,-1);
        if (saveList.size() != list.size()) {
            Redis.getRedisTemplate().delete(apiID);
            Redis.getRedisTemplate().opsForList().leftPushAll(apiID, list);
        }
    }

}
