package com.yeejoin.amos.boot.module.jxiop.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.ExStationBasicDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationBasicDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationInfoDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationRecordInfo;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 场站基础信息表 Mapper 接口
 *
 * @author system_generator
 * @date 2023-04-20
 */
public interface StationBasicMapper extends BaseMapper<StationBasic> {
    //分页
    List<StationBasicDto> queryPage(@Param("current")Long current, @Param("size")Long size,
                                    @Param("stationMasterName") String stationMasterName,
                                    @Param("stationName") String stationName,
                                    @Param("stationType")String stationType,
                                    @Param("orgCode") String orgCode);
    //统计
    List<StationBasicDto> queryPagecount(
            @Param("stationMasterName") String stationMasterName,
            @Param("stationName")String stationName,
            @Param("stationType")String stationType,
            @Param("orgCode")String orgCode);
    //删除
    int deleteList(String ids);
    //导出
    List<ExStationBasicDto> getExStationBasicDto( @Param("stationMasterName") String stationMasterName,
                                                  @Param("stationName")String stationName,
                                                  @Param("stationType")String stationType,
                                                  @Param("orgCode")String orgCode,
                                                  @Param("ids")  String [] ids

    );

    //获取场站列表信息
    List<StationRecordInfo> getStationList(@Param("regionId")String regionId);
    int deleteStationCoordinateByStationid (@Param("sequence_nbr") Long sequence_nbr );
    int getStationPersonByStationID (@Param("sequence_nbr") String sequence_nbr );


}
