package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @Author cpp
 * @Description
 * @Date 2022/10/17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="OrgUsrDto", description="人员表")
public class OrgUsrDto extends BaseDto {

    private String bizOrgName;
    /**
     * 机构编码
     */
    private String bizOrgCode;
    /**
     * amos中公司/部门ID
     */
    private String amosOrgId;
    /**
     * amos中公司/部门编码
     */
    private String amosOrgCode;
    /**
     * 机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）
     */
    private String bizOrgType;
    /**
     * 所属建筑名称
     */
    private String buildName;
    /**
     * 所属建筑ID
     */
    private String buildId;
    /**
     * 归属机构/部门/人员
     */
    private String parentId;
    /**
     * 扩展属性1
     */
    private String orgExpandAttr1;
    /**
     * 扩展属性2
     */
    private String orgExpandAttr2;
    /**
     * 扩展属性3
     */
    private String orgExpandAttr3;
    /**
     * 扩展属性4
     */
    private String orgExpandAttr4;

    private String orgExpandAttr5;

    private String orgExpandAttr6;

    private String orgExpandAttr7;

    private String orgExpandAttr8;
    /**
     * 更新人
     */
    private String recUserName;
    /**
     * 更新人ID
     */
    private String recUserId;
    /**
     * 更新时间
     */
    private Date recDate;

    /**
     * 归属机构/部门/人员名称
     */
    private String parentName;
    /**
     * 唯一编号
     */
    private String code;
    /**
     * 省市区编号
     */
    private String pczCode;
    /**
     * 省市区名称
     */
    private String pczName;
}
