package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
/**
 * 考试记录表
 *
 * @author duanwei
 * @date 2021-02-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_person_exam_record")
@ApiModel(value="PersonExamRecord对象", description="考试记录表")
public class PersonExamRecord extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "考试id")
    private Long examId;

    @ApiModelProperty(value = "考试名称")
    private String examName;

    @ApiModelProperty(value = "userid")
    private Long userId;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "分数")
    private Integer score;

    @ApiModelProperty(value = "通过")
    private Integer qualified;

    @ApiModelProperty(value = "考试开始时间")
    private Date examStartTime;

    @ApiModelProperty(value = "考试结束时间")
    private Date examEndTime;


}
