package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.entity.dto.OrgUsrDto;
import com.yeejoin.equipmanage.common.utils.*;
import com.yeejoin.equipmanage.config.PersonIdentify;
import com.yeejoin.equipmanage.mapper.FireFightingSystemMapper;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificSerivce;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import com.yeejoin.equipmanage.service.IOrgUsrService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Jianqiang Gao
 * @title: DCenterController
 * <pre>
 * @description: 设备告警
 * </pre>
 * @date 2022/11/15 09:54
 */
@RestController
@Api(tags = "总部直流中心监管页面Api")
@RequestMapping(value = "/dc-center", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class DCenterController extends AbstractBaseController {

    @Autowired
    private IEquipmentSpecificAlarmService equipmentSpecificAlarmService;

    @Autowired
    private FireFightingSystemMapper fireFightingSystemMapper;

    @Autowired
    IFireFightingSystemService fireFightingSystemService;

    @Autowired
    IEquipmentSpecificSerivce specificService;

    @Autowired
    IOrgUsrService iOrgUsrService;

    /**
     * 直流中心告警列表分页，用于直流中心大数据查询分页，不建议再扩展联表查询
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", produces = "application/json;charset=UTF-8", notes = "列表分页查询")
    public ResponseModel listPage(@RequestParam(value = "alarmType", required = false) String alarmType,
                                  CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        List<CommonRequest> queryRequests = new ArrayList<>();
        CommonRequest request = new CommonRequest();
        request.setName("alarmType");
        request.setValue(StringUtil.isNotEmpty(alarmType) ? StringUtils.trimToNull(alarmType) : null);
        queryRequests.add(request);
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<Map<String, Object>> list = equipmentSpecificAlarmService.zlzxListPage(param);
        return CommonResponseUtil.success(list);
    }

    /**
     * 消防系统运行状态分页查询
     * @param bizOrgCode
     * @param commonPageable
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "消防系统运行状态分页查询")
    @GetMapping("/fireSysRunStatusPage")
    public ResponseModel fireSysRunStatusPage(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
                                              CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isBlank(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            if (!ValidationUtil.isEmpty(reginParams.getPersonIdentity())) {
                bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
            }
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemService.fireSysRunStatusPage(page, bizOrgCode));
    }


    /**
     * 获取消防系统总体运行情况
     * @throws Exception
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取消防系统告警状态信息", notes = "获取消防系统告警状态信息")
    @GetMapping(value = "/system/running/info")
    public ResponseModel getSystemRunningInfoList() throws Exception {
        return CommonResponseUtil.success(fireFightingSystemService.getSystemRunningInfoList());
    }

    /**
     * 获取消防设备数量
     * @throws Exception
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取消防设备数量", notes = "获取消防设备数量")
    @GetMapping(value = "/equip/info")
    public ResponseModel getEquipmentStatisticsInfo(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) throws Exception {
        return CommonResponseUtil.success(specificService.getEquipmentStatisticsInfo(bizOrgCode));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "消防水池液位")
    @GetMapping("/equip/water/info")
    public ResponseModel getWaterInfo(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getCenterWaterInfo(page, bizOrgCode));
    }

    /**
     * 换流站接入情况总览
     *
     * @return
     */
    @GetMapping(value = "/station/connect/state")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public ResponseModel getStationConnectStatus() {
        return CommonResponseUtil.success(fireFightingSystemService.getStationConnectStatus());
    }

    /**
     * 换流站接入状态统计
     *
     * @return
     */
    @GetMapping(value = "/station/status/statistics")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public ResponseModel getStationStatusStatistics() {
        return CommonResponseUtil.success(fireFightingSystemService.getStationStatusStatistics());
    }

    @RequestMapping(value = "/companyTree", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "电力公司树", notes = "电力公司树")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public ResponseModel<List<OrgUsrDto>> companyTreeByUserAndType() {
        List<OrgUsrDto> menus = iOrgUsrService.getCompanyTree();
        return CommonResponseUtil.success(menus);
    }

}
