package com.yeejoin.amos.patrol.business.vo;

public class CheckStatsVo {
	
	/**
	 * id
	 */
	private Long id;

	/**
	 * 项目名称（统计口径）
	 */
	private String name;
	
	/**
	 * 实际巡检次数
	 */
	private Long realCheckNum = 0l;
	
	/**
	 * 计划巡检次数
	 */
	private Long planCheckNum = 0l;
	
	/**
	 * 计划完成次数
	 */
	private Long planFinishNum = 0l;
	
	/**
	 * 漏检次数（=计划次数-计划完成次数）
	 */
	private Long omissionNum = 0l;

	/**
	 * 漏检率%
	 */
	private int omissionRate;
	
	/**
	 * 不合格数
	 */
	private Long notOK = 0l;
	
	/**
	 * 不合格率%
	 */
	private int notOKRate;
	
	/**
	 * 评分
	 */
	private int score;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getRealCheckNum() {
		return realCheckNum;
	}

	public void setRealCheckNum(Long realCheckNum) {
		this.realCheckNum = realCheckNum;
	}

	public Long getPlanCheckNum() {
		return planCheckNum;
	}

	public void setPlanCheckNum(Long planCheckNum) {
		this.planCheckNum = planCheckNum;
	}

	public Long getPlanFinishNum() {
		return planFinishNum;
	}

	public void setPlanFinishNum(Long planFinishNum) {
		this.planFinishNum = planFinishNum;
	}

	public Long getOmissionNum() {
		return omissionNum = planCheckNum - planFinishNum;
	}

	public void setOmissionNum(Long omissionNum) {
		this.omissionNum = omissionNum;
	}

	public int getOmissionRate() {
		if (planCheckNum == 0) {
			omissionRate = 0;
		} else {
			omissionRate = (int) (omissionNum / planCheckNum) * 100;
		}
		return omissionRate;
	}

	public void setOmissionRate(int omissionRate) {
		this.omissionRate = omissionRate;
	}

	public Long getNotOK() {
		return notOK;
	}

	public void setNotOK(Long notOK) {
		this.notOK = notOK;
	}

	public int getNotOKRate() {
		if (realCheckNum == 0) {
			notOKRate = 0;
		} else {
			notOKRate = (int) (notOK / realCheckNum) * 100;
		}
		return notOKRate;
	}

	public void setNotOKRate(int notOKRate) {
		this.notOKRate = notOKRate;
	}

	public int getScore() {
		return score;
	}

	public void setScore(int score) {
		this.score = score;
	}
}
