package com.yeejoin.amos.boot.module.common.api.enums;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public enum BusinessTypeEnum {
    AZGZ("azgz","安装告知"),
    JDJY("jdjy","监督检验"),

    SYDJ("sydj","使用登记"),

    DQJY("dqjy","定期检验"),
    BGDJ("bgdj","变更登记"),
    ZXBX("zxbx","注销报销");


    private BusinessTypeEnum(String code, String name){
        this.code=code;
        this.name=name;
    }

    private String code;

    private String name;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static List<HashMap<String,Object>> getEnumList() {
        List<HashMap<String, Object>> list = new ArrayList<>();
        for (BusinessTypeEnum testEnum : EnumSet.allOf(BusinessTypeEnum.class)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("title",testEnum.name);
            map.put("value",testEnum.code);
            list.add(map);
        }
        return list;
    }

}
