package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 压力容器
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_special_pres_container")
public class SpecialPresContainer extends AbstractBaseEntity {

	private static final long serialVersionUID = 1L;
	/**
	 * 设备全省唯一编号
	 */
	@TableField("sequence_code")
	private String sequenceCode;
	/**
	 * 容器内径（mm）
	 */
	@TableField("container_bore")
	private String containerBore;
	/**
	 * 筒体材料
	 */
	@TableField("cylinder_material")
	private String cylinderMaterial;
	/**
	 * 封头材料
	 */
	@TableField("head_material")
	private String headMaterial;
	/**
	 * 内衬材料
	 */
	@TableField("lining_material")
	private String liningMaterial;
	/**
	 * 夹套材料
	 */
	@TableField("jacket_material")
	private String jacketMaterial;
	/**
	 * 筒体厚度（mm）
	 */
	@TableField("cylinder_thickness")
	private String cylinderThickness;
	/**
	 * 封头厚度（mm）
	 */
	@TableField("head_thickness")
	private String headThickness;
	/**
	 * 内衬厚度（mm）
	 */
	@TableField("lining_thickness")
	private String liningThickness;
	/**
	 * 夹套厚度（mm）
	 */
	@TableField("jacket_thickness")
	private String jacketThickness;
	/**
	 * 容器容积m³
	 */
	@TableField("container_volume")
	private String containerVolume;
	/**
	 * 容器高（长）（mm）
	 */
	@TableField("container_high")
	private String containerHigh;
	/**
	 * 壳体重量（Kg）
	 */
	@TableField("shell_weight")
	private String shellWeight;
	/**
	 * 内件重量（Kg）
	 */
	@TableField("internals_weight")
	private String internalsWeight;
	/**
	 * 充装重量（Kg）
	 */
	@TableField("filling_weight")
	private String fillingWeight;
	/**
	 * 有无保温绝热
	 */
	@TableField("is_thermal_insulation")
	private String isThermalInsulation;
	/**
	 * 壳程设计压力（MPa）
	 */
	@TableField("shell_design_pressure")
	private String shellDesignPressure;
	/**
	 * 壳程设计温度（℃）
	 */
	@TableField("shell_design_temperature")
	private String shellDesignTemperature;
	/**
	 * 壳程最高压力（MPa）
	 */
	@TableField("shell_highest_pressure")
	private String shellHighestPressure;
	/**
	 * 管程设计压力（MPa）
	 */
	@TableField("tube_design_pressure")
	private String tubeDesignPressure;
	/**
	 * 管程设计温度（℃）
	 */
	@TableField("tube_design_temperature")
	private String tubeDesignTemperature;
	/**
	 * 管程最高工作压力（MPa）
	 */
	@TableField("tube_highest_pressure")
	private String tubeHighestPressure;
	/**
	 * 夹套设计压力（MPa）
	 */
	@TableField("jacket_design_pressure")
	private String jacketDesignPressure;
	/**
	 * 夹套设计温度（℃）
	 */
	@TableField("jacket_design_temperature")
	private String jacketDesignTemperature;
	/**
	 * 夹套最高工作压力（MPa）
	 */
	@TableField("jacket_highest_pressure")
	private String jacketHighestPressure;
	/**
	 * 壳程介质
	 */
	@TableField("shell_medium")
	private String shellMedium;
	/**
	 * 管程介质
	 */
	@TableField("tube_medium")
	private String tubeMedium;
	/**
	 * 夹套介质
	 */
	@TableField("jacket_medium")
	private String jacketMedium;
	/**
	 * 氧舱照明
	 */
	@TableField("oxygen_lighting")
	private String oxygenLighting;
	/**
	 * 氧舱空调电机
	 */
	@TableField("oxygen_air_conditioning")
	private String oxygenAirConditioning;
	/**
	 * 氧舱测氧方式
	 */
	@TableField("oxygen_measurement_mode")
	private String oxygenMeasurementMode;
	/**
	 * 罐车牌号
	 */
	@TableField("pot_car_num")
	private String potCarNum;
	/**
	 * 罐车结构型式
	 */
	@TableField("pot_car_structural_style")
	private String potCarStructuralStyle;
	/**
	 * 罐车底盘号码
	 */
	@TableField("pot_car_chassis_num")
	private String potCarChassisNum;

}
