package com.yeejoin.amos.api.openapi.face.service;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;



public class AppBaseService<V, P,  M extends BaseMapper<P>> extends BaseService<V,P,M>{

    @Autowired
    private RedisTemplate redisTemplate;

    public String getAppId() {
        String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX, RequestContext.getToken());
        BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
        return bizTokenModel.getAppId();
    }

}
