package com.yeejoin.amos.api.openapi.face.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.SpecialElevatorModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.SpecialElevatorMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.SpecialElevator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 电梯 服务类
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@Component
public class SpecialElevatorService
                extends BaseService<SpecialElevatorModel, SpecialElevator, SpecialElevatorMapper> {

        /**
         * 分页查询
         */
        public Page<SpecialElevatorModel> queryForTmSpecialElevatorPage(Page page, String agencyCode) {
                return this.queryForPage(page, null, false, agencyCode);
        }

        /**
         * 列表查询 示例
         */
        public List<SpecialElevatorModel> queryForTmSpecialElevatorList(String agencyCode) {
                return this.queryForList("", false, agencyCode);
        }

		public String createSpecialElevator(List<SpecialElevatorModel> model) {
			// TODO Auto-generated method stub
			if (ValidationUtil.isEmpty(model))
				throw new BadRequest("电梯信息数据为空.");
	    	
			for (SpecialElevatorModel specialElevatorModel : model) {
				specialElevatorModel.setRecDate(new Date());
				specialElevatorModel.setAppId(getAppId());
				this.createWithModel(specialElevatorModel);
			}
			return "OK";
		}
		private String getAppId() {
			String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
	    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
	    	return bizTokenModel.getAppId();
		}
	    @Autowired
	    private RedisTemplate redisTemplate;
}
