package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.face.model.UseInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.UseInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.UseInfo;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * 特种设备基本信息-使用信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class UseInfoService extends AppBaseService<UseInfoModel, UseInfo, UseInfoMapper> {

    /**
     *
     * 新增使用信息
     *
     * @param model 使用信息实体类集合
     * @return 成功返回“OK”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveUseInfo(List<UseInfo> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("使用信息为空.");
        }

        for (UseInfo models : model) {
            checkModel(models);
            models.setRecDate(new Date());
            models.setAppId(getAppId());
        }
        this.saveBatch(model);
        return "OK";
    }

    /**
     * 信息校验
     *
     * @param models
     */
    private static void checkModel(UseInfo models) {
        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
            throw new BadRequest("设备唯一标识码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getUseUnitCreditCode())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"使用单位统一信用代码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getUseUnitName())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"使用单位名称不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getUseInnerCode())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"使用内部编号不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getUseDate())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"投入使用日期不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getAreaCode())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备所在地区代码不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getProvince())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备使用地点_省不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getCity())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备使用地点_市不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getCounty())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备使用地点_区（县）不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getStreet())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备使用地点_街道（镇）不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getUsePlace())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备使用场所(住宅小区、商业单位、学校、医院、政府机关、重要公共场所)不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getAddress())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备详细使用地址不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSafetyManager())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"安全管理员不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getPhone())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"安全管理员移动电话不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getPhone())) {
            throw new BadRequest("设备标识码为："+models.getEquState()+"的设备，"+"设备状态(1在用2停用3报废 4注销5迁出 6拆除 7目录外 8非法设备)不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSyncDate())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
        }
        if(ValidationUtil.isEmpty(models.getSyncState())) {
            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
        }
    }
}

