package com.yeejoin.amos.boot.module.ccs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireLatentDangerDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireLatentDanger;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 隐患信息 Mapper 接口
 *
 * @author system_generator
 * @date 2021-11-09
 */
public interface FireLatentDangerMapper extends BaseMapper<FireLatentDanger> {
    /**
     * 隐患列表倒序列表
     *
     * @param top         限制w
     * @param stationCode 站code
     * @return List<FireLatentDangerDto>
     */
    List<FireLatentDangerDto> queryDangerList(@Param("top") Long top, @Param("stationCode") String stationCode);

    /**
     * 隐患分组列表
     *
     * @param stationCode 换流站编号
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> dangerStateGroupMap(String stationCode);
}
