package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author ZeHua Li
 * @date 2020/11/12 14:39
 * @since v2.0
 */
@Data
@TableName("wl_building")
@ApiModel(value = "Building对象", description = "消防建筑")
public class Building extends BaseEntity {
    @ApiModelProperty(value = "编码")
    @TableField(value = "code")
    private String code;
    @ApiModelProperty(value = "名称")
    @TableField(value = "name")
    private String name;
    @ApiModelProperty(value = "地址")
    @TableField(value = "address")
    private String address;
    @ApiModelProperty(value = "类型（数据来自于装备定义--其他类消防装备器材--消防重点部位下面的选项）")
    @TableField(value = "equipment_code")
    private String equipmentCode;
    @ApiModelProperty(value = "数据来自于消防设施系统列表")
    @TableField(value = "system_id")
    private Long systemId;
    @ApiModelProperty(value = "面积(㎡)")
    @TableField(value = "area_measure")
    private Double areaMeasure;
    @ApiModelProperty(value = "高度/最大液位(m)")
    @TableField(value = "height")
    private Double height;
    @ApiModelProperty(value = "低度/最小液位(m)")
    @TableField(value = "low")
    private Double low;
    @ApiModelProperty(value = "设计容量(m³)")
    @TableField(value = "design_capacity")
    private Double designCapacity;
    @ApiModelProperty(value = "告警液位(㎡)")
    @TableField(value = "warn_height")
    private Double warnHeight;
    @ApiModelProperty(value = "区域id")
    @TableField(value = "region_id")
    private Long regionId;
    @ApiModelProperty(value = "区域名称")
    @TableField(value = "region_name")
    private String regionName;
    @ApiModelProperty(value = "创建人ID")
    @TableField(value = "creator_id")
    private Long creatorId;
    @ApiModelProperty(value = "创建人名")
    @TableField(value = "creator_name")
    private String creatorName;
    @ApiModelProperty(value = "公司名称")
    @TableField(value = "company_name")
    private String companyName;
    @ApiModelProperty(value = "公司code")
    @TableField(value = "org_code")
    private String orgCode;
    @ApiModelProperty(value = "部门名称")
    @TableField(value = "department_name")
    private String departmentName;
    @ApiModelProperty(value = "部门code")
    @TableField(value = "department_orgcode")
    private String departmentOrgcode;
    @ApiModelProperty(value = "分类名称")
    @TableField(value = "equipment_category_name")
    private String equipmentCategoryName;
}
