package com.yeejoin.equipmanage.common.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 动态表单树形分组表
 *
 * @author duanwei
 * @date 2021-03-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "wl_dynamic_form_group",autoResultMap = true)
@ApiModel(value = "DynamicFormGroup对象", description = "动态表单树形分组表")
public class DynamicFormGroup extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "分组名称")
    private String groupName;

    @ApiModelProperty(value = "分组编号")
    private String groupCode;

    @ApiModelProperty(value = "分组类型（点位图过滤用）")
    private String groupType;

    @ApiModelProperty(value = "父级id")
    private Long parentId;

    @ApiModelProperty(value = "更新者id")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Long creatorId;

    @ApiModelProperty(value = "是否必须：0-否；1-是；控制前端tab是否可勾选掉")
    private Boolean isMust;

    @ApiModelProperty(value = "分组配置")
    @TableField(typeHandler = JacksonTypeHandler.class)
    private JSONObject groupConfig;

    @ApiModelProperty(value = "组织机构")
    private String orgCode;

    @ApiModelProperty(value = "关联id")
    private Long relationId;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @TableField(exist = false)
    private Boolean isDelete = false;


    @TableField(exist = false)
    private List<DynamicFormColumn> formColumns;

    @TableField(exist = false)
    private List<DynamicFormGroup> children;
}
