package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author ZeHua Li
 * @date 2020/10/30 11:12
 * @since v2.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("wl_equipment_specific_index")
@ApiModel(value = "EquipmentSpecificIndex对象", description = "性能指标参数")
public class EquipmentSpecificIndex extends BaseEntity {

    @ApiModelProperty(value = "单个设备id")
    @TableField("equipment_specific_id")
    private Long equipmentSpecificId;

    @ApiModelProperty(value = "值")
    @TableField("value")
    private String value;

    @ApiModelProperty(value = "值说明")
    @TableField("value_label")
    private String valueLabel;

    @ApiModelProperty(value = "性能指标对应id")
    @TableField("equipment_index_id")
    private Long equipmentIndexId;

    @ApiModelProperty(value = "更新时间")
    @TableField("update_date")
    private Date updateDate;

    @ApiModelProperty(value = "装备名称（冗余字段）")
    @TableField("equipment_specific_name")
    private String equipmentSpecificName;
//   equipmentSpecialName 

    @ApiModelProperty(value = "指标名称（冗余字段）")
    @TableField("equipment_index_name")
    private String equipmentIndexName;

    @ApiModelProperty(value = "指标key（冗余字段）")
    @TableField("equipment_index_key")
    private String equipmentIndexKey;
    
    /**
     * 颜色
     */
    @TableField(value = "emergency_level_color")
    private String emergencyLevelColor;

    /**
     * 是否告警:0-否；1-是
     */
    @TableField(value = "is_alarm")
    private Integer isAlarm;

    /**
     * 紧急程度枚举（1：紧急，2：严重，3：轻微，4：正常，5：无效，6：备用，7：其他）
     */
    @TableField(value = "emergency_level")
    private String emergencyLevel;

    /**
     * 紧急程度描述
     */
    @TableField(value = "emergency_level_describe")
    private String emergencyLevelDescribe;

    @ApiModelProperty(value = "iot数据上报唯一id")
    private String traceId;
    
    @TableField(exist = false)
    private String nameKey;

    @TableField(exist = false)
    private String code;

    @TableField(exist = false)
    private String iotCode;

    @TableField(exist = false)
    private String type;

    @TableField(exist = false)
    private String orgCode;

    @ApiModelProperty(value = "指标类型编码")
    @TableField(value = "type_code")
    private String typeCode;

    @TableField(exist = false)
    private String typeName;

    @TableField(exist = false)
    private String indexName;
    

    
    @TableField(exist = false)
    private String equipmentSpecificIndexName;

    @TableField(exist = false)
    private String indexUnitName;

    @TableField(exist = false)
    private String qrCode;

    @TableField(exist = false)
    private String equipmentCode;

    @TableField(exist = false)
    private Long equipmentId;

    @TableField(exist = false)
    private Long equipmentDetailId;

    @TableField(exist = false)
    private String alamReason;

    @ApiModelProperty(value = "设备CODE")
    @TableField(exist = false)
    private String equipmentSpecificCode;

    @ApiModelProperty(value = "设备所属系统ids")
    @TableField(exist = false)
    private String systemId;
    
    @ApiModelProperty(value = "详细位置")
    @TableField(exist = false)
    private String location;
    
    @ApiModelProperty(value = "所属建筑id")
    @TableField(exist = false)
    private String buildId;

    @ApiModelProperty(value = "绑定视屏数量")
    @TableField(exist = false)
    private int num;

    /**
     * 机构/部门名称
     */
    @TableField(exist = false)
    private String bizOrgName;

    /**
     * 机构编码
     */
    @TableField(exist = false)
    private String bizOrgCode;

    @ApiModelProperty(value = "装备系统code")
    @TableField(exist = false)
    private String specificCode;

    @ApiModelProperty(value = "装备定义名称")
    @TableField(exist = false)
    private String equipmentName;

    @TableField(exist = false)
    private String equipmentType;

    // 直流中心方便前端刷新展示
    @TableField(exist = false)
    private String UUID;

    @TableField(value = "unit")
    private String unit;

    @ApiModelProperty(value = "信号的索引键key，用于唯一索引信号")
    @TableField(value = "index_address")
    private String indexAddress;

    @ApiModelProperty(value = "品质，0为有效，1为无效")
    @TableField(value = "quality")
    private String quality;

    @ApiModelProperty(value = "测点类型，analog/state")
    @TableField(value = "data_type")
    private String dataType;

    @ApiModelProperty(value = "时间")
    @TableField(value = "time_stamp")
    private String timeStamp;

    /**
     * 指标值枚举
     */
    @ApiModelProperty(value = "指标值枚举")
    @TableField("value_enum")
    private String valueEnum;

    @ApiModelProperty(value = "网关标识")
    @TableField(value = "gateway_id")
    private String gatewayId;

    @ApiModelProperty(value = "告警规则")
    @TableField(value = "alarm_rule")
    private String alarmRule;

    @ApiModelProperty(value = "是否遥测")
    @TableField(value = "is_trend")
    private Boolean isTrend;
}
