package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 仓库信息
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_warehouse")
@ApiModel(value = "Warehouse对象", description = "仓库信息")
public class Warehouse extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "仓库名称")
	private String name;

	@ApiModelProperty(value = "联系电话")
	private String telephone;

	@ApiModelProperty(value = "值班电话")
	private String dutyTelephone;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "等级")
	private String level;
	
	@ApiModelProperty(value = "负责人")
	private String owner;

	@ApiModelProperty(value = "创建人")
	@TableField(value = "user_id", fill = FieldFill.INSERT)
	private Long userId;

	@ApiModelProperty(value = "创建人名称")
	@TableField(value = "user_Name", fill = FieldFill.INSERT)
	private String userName;

	@ApiModelProperty(value = "组织结构")
	@TableField(value = "org_code", fill = FieldFill.INSERT)
	private String orgCode;

	@ApiModelProperty(value = "公司名称")
	@TableField(value = "company_name", fill = FieldFill.INSERT)
	private String companyName;
	
	@ApiModelProperty(value = "预控系统中的ID字段")
    private Long sourceId;
    
    @ApiModelProperty(value = "预控系统中的code字段")
    private String sourceCode;

}
