package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_spare_equipment")
@ApiModel(value = "WlSpareEquipment对象", description = "设备平台备品备件管理")
public class WlSpareEquipment extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableField("name")
    private String name; // 装备名称

    @TableField("equip_model_id")
    private Long equipModelId; // 装备定义id

    @TableField("equip_model_name")
    private String equipModelName; // 装备定义名称

    @TableField("equip_model_code")
    private String equipModelCode; // 装备定义编码

    @TableField("equip_category_id")
    private Long equipCategoryId; // 装备分类id

    @TableField("equip_category_name")
    private String equipCategoryName; // 装备分类名称

    @TableField("equip_category_code")
    private String equipCategoryCode; // 装备分类编码

    @TableField("stock_num")
    private Float stockNum; // 库存数量

    @TableField("manufacturer")
    private String manufacturer; // 生产厂家

    @TableField("manufacturer_id")
    private Long manufacturerId; // 生产厂家id

    @TableField("standard")
    private String standard; // 规格

    @TableField("brand")
    private String brand; // 品牌

    @TableField("production_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date productionDate; // 生产日期

    @TableField("purchase_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date purchaseDate; // 采购日期

    @TableField("warehouse_structure_id")
    private Long warehouseStructureId; // 存储位置id

    @TableField("warehouse_structure_code")
    private String warehouseStructureCode; // 存储位置code

    @TableField("warehouse_structure")
    private String warehouseStructure; // 存储位置

    @TableField("position")
    private String position; // 存储位置详情描述

    @TableField("unit")
    private String unit; // 计量单位

    @TableField("unit_id")
    private Long unitId; // 计量单位id

    @TableField("remark")
    private String remark; // 备注

    @TableField("biz_org_name")
    private String bizOrgName; // 机构名称

    @TableField("biz_org_code")
    private String bizOrgCode; // 机构编码

    @TableField("single")
    private Integer single; // 管理方式(默认单件)

    @TableField("is_delete")
    private Boolean isDelete = false; // 是否删除 0-否 1-是

    @TableField(exist = false)
    private List<UploadFile> img;

    @TableField(exist = false)
    private List<UploadFile> video;

    @TableField(exist = false)
    private List<UploadFile> certification;

    @TableField(exist = false)
    private List<UploadFile> instruction;

    @TableField(exist = false)
    private List<EquProperty> equPropertyList;

    @TableField(exist = false)
    private List<UploadFile> quality;

    @TableField(exist = false)
    private List<UploadFile> operation;

    @TableField(exist = false)
    private String agencyId;

    @TableField(exist = false)
    private Integer pageNum;

    @TableField(exist = false)
    private Integer pageSize;

    @TableField(exist = false)
    private String equipmentClassificationCode;

    @TableField(exist = false)
    private String industryCode;

    @TableField(exist = false)
    private String code; // 装备定义code筛选字段
    @TableField(exist = false)
    private String stockNumString;
}

