package com.yeejoin.equipmanage.common.entity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "消防资源监管子项DTO", description = "消防资源监管子项DTO")
public class FireResourceStatsDTO {
    @ApiModelProperty(value = "资源总数")
    private long totalCounts;

    @ApiModelProperty(value = "黄码资源数")
    private long yellowCounts;

    @ApiModelProperty(value = "红码资源数")
    private long redCounts;

    @ApiModelProperty(value = "异常百分比", notes = "非正常资源数/资源总数, 非正常资源数=黄码资源数+红码资源数")
    private Number abnormalRatio;
}
