package com.yeejoin.equipmanage.common.enums;

public enum BillContentEnum {
	ZB("1", "装备", "equipment"),
	CL("2", "车辆", "car"),
	MHYJ("3", "灭火药剂", "extinguishing "),
	RY("4", "人员", "people"),
	BPBJ("1", "备品备件", "spareEquipment");

	private String name;

	private String code;

	private String key;

	private BillContentEnum(String code, String name, String key) {
		this.code = code;
		this.name = name;
		this.key = key;
	}

	public String getName() {
		return name;
	}

	public String getCode() {
		return code;
	}

	public String getKey() {
		return key;
	}

	public static BillContentEnum getEnum(String code) {
		for (BillContentEnum bEnum : BillContentEnum.values()) {
			if (bEnum.getCode().equals(code)) {
				return bEnum;
			}
		}
		return null;
	}
}
