package com.yeejoin.equipmanage.common.enums;

public enum PressurePumpCheckEnum {

    LE("le", "小于等于"),
    GE("ge", "大于等于"),
    BE("be", "在两者之间");

    private String code;
    private String describe;

    private PressurePumpCheckEnum(String code, String describe) {
        this.code = code;
        this.describe = describe;
    }

    public String getCode() {
        return code;
    }

    public String getDescribe() {
        return describe;
    }

    public static PressurePumpCheckEnum getByCode(String code) {
        for (PressurePumpCheckEnum l : PressurePumpCheckEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }
}
