package com.yeejoin.equipmanage.common.enums;


/**
 * 画布资源枚举
 * @author DELL
 *
 */
public enum VideoTypeEnum {

	gun("枪机", "51000000"),
	ball("球机", "52000000");

    VideoTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    private String name;
    private String code;

    public String getName() {
        return name;
    }

    public String getCode() {
        return code;
    }
    

	public static String getCode(String name) {
		for (VideoTypeEnum c : VideoTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.code;
			}
		}
		return "";
	}
}
