package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 机场机位旋转角度
 *
 * @author litw
 * @date 2021-09-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_airport_stand")
public class AirportStand extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 机位号
     */
	@TableField("stand_code")
    private String standCode;

    /**
     * 坐标X
     */
	@TableField("coordinate_x")
    private String coordinateX;

    /**
     * 坐标Y
     */
	@TableField("coordinate_y")
    private String coordinateY;

    /**
     * 经度
     */
	@TableField("longitude")
    private String longitude;

    /**
     * 纬度
     */
	@TableField("latitude")
    private String latitude;

    /**
     * 更新时间
     */
	@TableField("update_time")
    private Date updateTime;

}
