package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 打卡记录
 *
 * @author system_generator
 * @date 2022-08-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_sign")
public class Sign extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 打卡人名字
     */
	@TableField("name")
    private String name;

    /**
     * 打卡人id
     */
	@TableField("user_id")
    private String signUserId;

    /**
     * 打卡人岗位
     */
	@TableField("job_title")
    private String jobTitle;

    /**
     * 打卡类型
     */
    @TableField("type")
    private String type;

    /**
     * 换流站code
     */
	@TableField("biz_org_code")
    private String bizOrgCode;

    /**
     * 换流站Name
     */
	@TableField("biz_org_name")
    private String bizOrgName;

    /**
     * 打卡时间
     */
	@TableField("date")
    private String date;

    /**
     * 打卡来源
     */
	@TableField("source")
    private String source;

    /**
     * 打卡图片
     */
	@TableField("photos")
    private String photos;

    /**
     * 备注
     */
	@TableField("remarks")
    private String remarks;

    /**
     * 打卡时间
     */
	@TableField("sign_time")
    private Date signTime;

    /**
     * 系统标识（数据隔离使用）
     */
	@TableField("app_key")
    private String appKey;

    /**
     * 组件机构
     */
	@TableField("org_code")
    private String orgCode;

    /**
     * 当日驻站消防队总人数(可变)
     */
    @TableField("person_of_day")
    private String personOfDay;

}
