package com.yeejoin.amos.boot.module.jcs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * <pre>
 * 联动控制器类型枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: ControllerTypeEnum.java, v 0.1 2021年8月20日 上午10:21:44 gwb Exp $
 */
@Getter
@AllArgsConstructor
public enum ControllerTypeEnum {

    BELL("1", "警铃", 1),
    BROADCAST("2", "广播", 2),
    DOOR("3", "车库门", 3);

    private String code;
    private String name;
    private int sort;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static ControllerTypeEnum getEnum(String code) {
        for (ControllerTypeEnum status : ControllerTypeEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }
}
