package com.yeejoin.amos.knowledgebase.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * <p>
 * 知识库内容交互计数表
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("knowledge_interaction_count")
public class KnowledgeInteractionCount extends BaseEntity {


	/**
	 * 操作类型(标签所有情况引用，标签被已审核/已发布文档引用,文档引用)
	 */
	@TableField("OPERATE_TYPE")
	private String operateType;
	/**
	 * 关联对象类型
	 */
	@TableField("ENTITY_TYPE")
	private String entityType;
	/**
	 * 关联对象id
	 */
	@TableField("ENTITY_ID")
	private String entityId;
	/**
	 * 计数
	 */
	@TableField("OPERATE_COUNT")
	private Integer operateCount;
	/**
	 * 机构编号
	 */
	@TableField("AGENCY_CODE")
	private String agencyCode;
}

