package com.yeejoin.precontrol.common.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
* 分包商评价记录表
*
* @author duanwei
* @date 2021-01-28
*/
    @Data
        @EqualsAndHashCode(callSuper = true)
    @Accessors(chain = true)
    @TableName("rpm_company_evaluation_log")
    @ApiModel(value="CompanyEvaluationLogDto", description="分包商评价记录表")
    public class CompanyEvaluationLogDto extends BaseEntity {

    private static final long serialVersionUID = 1L;


            @ApiModelProperty(value = "分包商id")
    private Long companyId;

            @ApiModelProperty(value = "评价人id")
    private Long evaluationUserId;

            @ApiModelProperty(value = "评价人名称")
    private String evaluationUserName;

            @ApiModelProperty(value = "评价内容")
    private String content;

            @ApiModelProperty(value = "评价等级")
    private String rate;


}
