package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author duanwei
 * @date 2020-07-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_bad_management")
@ApiModel(value = "BadManagement对象", description = "违规管理")
public class BadManagement extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "违规内容")
    private String body;
    @ApiModelProperty(value = "任务ID")
    private Long taskId;
    @ApiModelProperty(value = "分包商企业ID")
    private Long companyId;
    @ApiModelProperty(value = "分包商责任人")
    private Long personLiable;
    @ApiModelProperty(value = "违规类型")
    private String type;
    @ApiModelProperty(value = "违章性质")
    private String nature;
    @ApiModelProperty(value = "是否失效（判断红码统计）")
    private boolean notValid;
}
