package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 危险作业表
 *
 * @author duanwei
 * @date 2020-08-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_hazardous_work")
@ApiModel(value = "HazardousWork对象", description = "危险作业表")
public class HazardousWork extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "危险作业名称")
    private String name;

    @ApiModelProperty(value = "作业条件_输入项")
    private String conditions;

    @ApiModelProperty(value = "描述")
    private String remark;

    @ApiModelProperty(value = "编号")
    private String orderNo;

    @ApiModelProperty(value = "创建人id")
    private Long cPersonId;

    @ApiModelProperty(value = "组织机构")
    private String orgCode;


}
