package com.yeejoin.precontrol.common.entity.hk.model.dto;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: songLei
 * @Description: 海康接口请求参数
 * @Date: 2021/4/29 15:33
 * @Version: 1.0
 */
@Data
public class HKRequestDto implements Serializable {
    /**
     * 监控点唯一标识，
     * 可通过分页获取监控点资源获取
     */
    private String cameraIndexCode;
    /**
     * 码流类型：
     * 0:主码流
     * 1:子码流
     * 2:第三码流
     * 参数不填，默认为主码流
     */
    private Integer streamType;
    /**
     * 取流协议（应用层协议）：
     * “rtsp”:RTSP协议
     * “rtmp”:RTMP协议（只支持H264视频编码和AAC音频编码）
     * “hls”:HLS协议（HLS协议只支持海康SDK协议、EHOME协议、GB28181协议、ONVIF协议接入的设备；只支持H264视频编码和AAC音频编码）
     * 参数不填，默认为RTSP协议
     */
    private String protocol;
    /**
     * 传输协议（传输层协议）：
     * 0:UDP
     * 1:TCP
     * 默认是TCP
     * 注：GB28181 2011及以前版本只支持UDP传输
     */
    private Integer transmode;
    /**
     * 标识扩展内容，格式：key=value，
     * 多个扩展时，以“&”隔开；
     * 调用方根据其播放控件支持的解码格式选择相应的封装类型；支持的内容详见附录F expand扩展内容说明
     */
    private String expand;
    /**
     * 范围 ( 0 , ~ )，若是范围内数字超过实际最大页码值，返回最后一页记录
     * 注：0 < pageNo
     */
    private Integer pageNo;
    /**
     * 范围 ( 0 , 1000 ]
     * 注：0 < pageSize≤1000
     */
    private Integer pageSize;
    /**
     * 区域编号唯一标识；
     * 可通过区域信息接口获取
     */
    private String regionIndexCode;

    /**
     * 存储类型：
     * 0：中心存储
     * 1：设备存储
     * 默认为中心存储
     */
    private Integer recordLocation;
    /**
     * 开始查询时间（IOS8601格式：yyyy-MM-ddTHH:mm:ss.SSSXXX）
     * 例如北京时间：
     * 2017-06-14T00:00:00.000+08:00
     */
    private String beginTime;
    /**
     * 结束查询时间，开始时间和结束时间相差不超过三天；
     * （IOS8601格式：yyyy-MM-ddTHH:mm:ss.SSSXXX）例如北京时间：
     * 2017-06-15T00:00:00.000+08:00
     */
    private String endTime;
    /**
     * 分页查询id，上一次查询返回的uuid，用于继续查询剩余片段，默认为空字符串
     */
    private String uuid;
    /**
     * regionIndexCode为空时，regionIndexCode会有平台生成，三方用户需要通过clientid和regionIndexCode进行关联。
     * 所以建议每次接口调用，clientid保持唯一。1~10个字符，只支持数字。
     * 注释：ISC不对clientid做校验和存储
     */
    private Integer clientId;
    /**
     * 父区域唯一标识码
     */
    private String parentIndexCode;
    /**
     * 父区域名称，同一级不可重复
     */
    private String regionName;
    /**
     * 外码编码，regionType为12时有效，regionType为10时忽略该值
     */
    private String regionCode;
    /**
     * 区域类型
     * 10: 普通区域
     * 12: 楼栋单元
     */
    private Integer regionType;
    /**
     * 区域描述信息
     */
    private String description;
    /**
     * 摄像头编码
     */
    private List<String> indexCodes;

}
