package com.yeejoin.precontrol.common.enums;

public enum PersonBlackEnum {
	
	NO(0, "是"),

	YES(1, "否");

	private int type;

	private String name;

	PersonBlackEnum(int type, String name) {
		this.type = type;
		this.name = name;
	}
	
	public long getLongType() {
		return Long.valueOf(type);
	}

	public int getType() {
		return type;
	}

	public String getName() {
		return name;
	}

	public static String getNameByType(int type) {
		String name = null;
		for (PersonBlackEnum enumOne : PersonBlackEnum.values()) {
			if (enumOne.getType() == type) {
				name = enumOne.getName();
				break;
			}
		}
		return name;
	}
}
