package com.yeejoin.precontrol.common.enums;

/**
 * 角色枚举
 */
public enum RoleEnum {
    /*
     * 分包商管理员
     */
    FBS_ADMIN("分包商管理员", "fbs_admin"),
    /*
     * 分包商班长
     */
    FBS_MONITOR("分包商班长", "fbs_monitor"),

    /*
     * 分包商技术员
     */
    FBS_TECHNICIAN("分包商技术员", "fbs_technician"),
    /*
     * 分包商安全员
     */
    FBS_SECURITY("分包商安全员", "fbs_security"),
    /*
     * 分包商质量员
     */
    FBS_QC("分包商质量员", "fbs_qc"),
    /*
     * 分包商施工员
     */
    FBS_WORKER("分包商施工员", "fbs_worker"),
    /*
     * 分包商主管
     */
    FBS_DIRECTOR("分包商主管", "fbs_director");

    private String label;
    private String value;

    RoleEnum(String label, String value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String getLabelByValue(String value) {
        String label = null;
        for (ContractTypeEum type : ContractTypeEum.values()) {
            if (type.getValue().equals(value)) {
                label = type.getLabel();
                break;
            }
        }
        return label;
    }
}
