package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.HazardousWorkPageDto;
import com.yeejoin.precontrol.common.entity.HazardousWork;
import com.yeejoin.precontrol.common.vo.HazardousWorkPageVo;
import com.yeejoin.precontrol.common.vo.HazardousWorkVo;

/**
 * 危险作业表 服务类
 *
 * @author duanwei
 * @date 2020-08-24
 */
public interface IHazardousWorkService extends IService<HazardousWork> {

    /**
     * 危险作业列表
     * @param pageable
     * @param hazardousWorkPageDto
     * @return
     */
    IPage<HazardousWorkPageVo> listByPage(CommonPageableDto pageable, HazardousWorkPageDto hazardousWorkPageDto);


    /**
     * 根据id危险作业查询全部数据
     *
     * @param id
     * @return
     */
    HazardousWorkVo getHazardousWorkVo(Long id);


}
