package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.entity.PersonExamRecord;
import com.yeejoin.precontrol.common.mapper.PersonExamRecordMapper;
import com.yeejoin.precontrol.common.service.IPersonExamRecordService;
import com.yeejoin.precontrol.common.vo.PersonExamRecordVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

/**
 * 考试记录表 服务实现类
 *
 * @author duanwei
 * @date 2021-02-23
 */
@Service
public class PersonExamRecordServiceImpl extends ServiceImpl<PersonExamRecordMapper, PersonExamRecord>
		implements IPersonExamRecordService {

	@Override
	public Page<PersonExamRecordVo> pageInfo(@Param("param") CommonPageableDto pageable,
			@Param("param") PersonExamRecordVo personExamRecordVo) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<PersonExamRecord> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		return this.baseMapper.pageList(page, personExamRecordVo);
	}

}
