package com.yeejoin.precontrol.common.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 分包商评价记录表
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Data
@Accessors(chain = true)
@TableName("rpm_company_evaluation_log")
@ApiModel(value = "CompanyEvaluationLogVo", description = "分包商评价记录表")
public class CompanyEvaluationLogVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "分包商id")
    private Long companyId;

    @ApiModelProperty(value = "评价人id")
    private Long evaluationUserId;

    @ApiModelProperty(value = "评价人名称")
    private String evaluationUserName;

    @ApiModelProperty("评价人头像")
    @ImagePrefix
    private String headPhoto;

    @ApiModelProperty(value = "评价内容")
    private String content;

    @ApiModelProperty(value = "评价等级")
    private Integer rate;

    @ApiModelProperty(value = "评价人名称")
    private String createDate;

    @ApiModelProperty(value = "任务id")
    private Long taskId;

    @ApiModelProperty(value = "分包商名称")
    private String companyName;

    @ApiModelProperty(value = "分包商图片")
    @ImagePrefix
    private String photo;
}
