package com.yeejoin.amos.boot.module.common.biz.controller;

import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsrAuth;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrAuthServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
* 
*
* @author tb
* @date 2021-06-18
*/
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/org-usr-auth")
public class OrgUsrAuthController extends BaseController {

    @Autowired
    OrgUsrAuthServiceImpl iOrgUsrAuthService;

    /**
    * 新增
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveOrgUsrAuth(HttpServletRequest request, @RequestBody OrgUsrAuth orgUsrAuth){
        return iOrgUsrAuthService.save(orgUsrAuth);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iOrgUsrAuthService.removeById(id);
    }




    /**
    * 修改
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdOrgUsrAuth(HttpServletRequest request, @RequestBody OrgUsrAuth orgUsrAuth){
        return iOrgUsrAuthService.updateById(orgUsrAuth);
    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public OrgUsrAuth selectById(HttpServletRequest request, @PathVariable Long id){
        return iOrgUsrAuthService.getById(id);
    }



    /**
    * 列表分页查询
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<OrgUsrAuth> listPage(String pageNum,String pageSize, OrgUsrAuth orgUsrAuth){

        Page<OrgUsrAuth> pageBean;
        QueryWrapper<OrgUsrAuth> orgUsrAuthQueryWrapper = new QueryWrapper<>();
        Class<? extends OrgUsrAuth> aClass = orgUsrAuth.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                ReflectionUtils.makeAccessible(field);
                Object o = field.get(orgUsrAuth);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(orgUsrAuth);
                        orgUsrAuthQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(orgUsrAuth);
                        orgUsrAuthQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(orgUsrAuth);
                        orgUsrAuthQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(orgUsrAuth);
                        orgUsrAuthQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<OrgUsrAuth> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iOrgUsrAuthService.page(pageBean, orgUsrAuthQueryWrapper);
            return page;
        }
    }

