package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.entity.dto.EquipmentSpecificDTO;
import com.yeejoin.equipmanage.common.entity.vo.ComplementCodeVO;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.IEquipmentSpecificSerivce;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author litw
 * @date 2024-01-05
 */
@RestController
@Api(tags = "浙江省设备平台右屏接口")
@RequestMapping(value = "/fire-buss-platform")
@Slf4j
public class FireBussForEquPlatformController extends AbstractBaseController {


    @Autowired
    IEquipmentSpecificSerivce equipmentSpecificSerivce;

    @RequestMapping(value = "/patrol",method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防巡查")
    public ResponseModel<List<Map<String, Object>>>  getPatrolInfo(@RequestParam(required = false) String bizOrgCode){
        ReginParams reginParams = getSelectedOrgInfo();
        bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        List<Map<String, Object>> map = equipmentSpecificSerivce.getZJPatrolStatics(bizOrgCode);
        return CommonResponseUtil.success(map);
    }

    @RequestMapping(value = "/scrap",method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("消防报废信息")
    public ResponseModel<List<Map<String, Object>>>  getScrapInfo(@RequestParam(required = false) String bizOrgCode){
        ReginParams reginParams = getSelectedOrgInfo();
        bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        List<Map<String, Object>> map = equipmentSpecificSerivce.getZJScrapStatics(bizOrgCode);
        return CommonResponseUtil.success(map);
    }


    /**
     * 更换报废分页
     *
     * @return
     */
    @RequestMapping(value = "/wwx/page", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "更换报废分页", notes = "更换报废分页-未维修，未报废")
    public IPage<Map<String,Object>> selectZJEquipmentSpecificWWX(@RequestBody EquipmentSpecificDTO equipmentSpecific) {
        return equipmentSpecificSerivce.selectZJEquipmentSpecificWWX(equipmentSpecific);
    }

    /**
     * 更换报废分页
     *
     * @return
     */
    @RequestMapping(value = "/wwx/ids", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "更换报废业务字段", notes = "更换报废业务字段修，未报废")
    public List<Map<String,Object>> selectZJEquipmentSpecificWWXByIds(@RequestBody Map<String, Object> objectMap) {
        return equipmentSpecificSerivce.selectZJEquipmentSpecificWWXByIds(objectMap.get("bussIds").toString());
    }

}
