package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificRelation;
import com.yeejoin.equipmanage.common.entity.vo.AssociatedEquipmentVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentDetailVO;
import org.apache.ibatis.annotations.Param;
import org.mapstruct.Mapper;

import java.util.List;

/**
 * @author keyong
 * @title: EquipmentSpecificRelationMapper
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/1/14 14:25
 */
@Mapper
public interface EquipmentSpecificRelationMapper extends BaseMapper<EquipmentSpecificRelation> {

    /**
     * 获取设备的联动设备分页列表
     *
     * @param page 分页参数
     * @param equipId 设备id
     * @param type 关联设备类型（1-安防设备，2-消防设备）
     * @return
     */
    IPage<AssociatedEquipmentVO> getAssociatedEquipmentPageList(Page page, @Param("equipId") Long equipId,
                                                                @Param("type") Integer type);

    /**
     * 获取设备的联动设备
     *
     * @param eqpSpecificId 设备id
     * @param type 关联设备类型（1-安防设备，2-消防设备）
     * @return
     */
    List<EquipmentDetailVO> getAssociatedEqpList(@Param("eqpSpecificId") Long eqpSpecificId, @Param("type") Integer type);

    /**
     * 根据设备id查询已存在关联设备的关系记录
     *
     * @param eqpSpecificId
     * @return
     */
    List<Long> queryByRelatedEqpSpecIds(@Param("eqpSpecificId") Long eqpSpecificId);

    /**
     * 根据设备分类id和设备名称查询设备列表
     *
     * @param categoryIdList 设备分类id
     * @param eqpName 设备名称
     * @return
     */
    List<EquipmentDetailVO> getEqpDetailCategoryIdAndName(@Param("categoryIdList") List<Long> categoryIdList,
                                                          @Param("eqpName")String eqpName);
}
