package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.dto.FileManageDto;
import com.yeejoin.equipmanage.common.entity.FileManage;

import java.util.Map;

public interface FileManageService extends IService<FileManage> {

    /**
     * 添加文件
     * @param dto 数据信息
     * @param reginParams 登录信息
     */
    void saveFileManage(FileManageDto dto);

    /**
     * 列表查询
     * @param dto 筛选条件
     * @return 数据结果
     */
    Map<String, Object> getFileManageByPage(FileManageDto dto);

    /**
     * 列表行点击查看按钮
     * @param dto 筛选条件
     * @return 数据结果
     */
    Page<Map<String, Object>> getFileManageByName(FileManageDto dto);
}
