package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.FormGroup;

import java.util.Map;

/**
 * @author DELL
 */
public interface IFormGroupService extends IService<FormGroup> {
    /**
     * @Description 根据groupCode查询
     * @param groupCode
     * @Return FormGroup
     * @Date 2020/12/18 10:01
     */
    FormGroup allowOperationByGroupCode(String groupCode);

    /**
     * 按照唯一主键查询
     * @param groupCode 编号
     * @return FormGroup
     */
    FormGroup getByUniqueKey(String groupCode);

    /**
     * 查询所有的树操作数据
     * @return Map<String, Object>
     */
    Map<String, Object> getAllOperation();
}
